@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">EMPLOYEE PANEL</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">DASHBOARD</a></li>
        <li class="active">CASH BACK DETAILS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">CASH BACK DETAILS</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{ url('emp_bonus_report') }}"  method="post" accept-charset="utf-8">
						
                                    {{ csrf_field() }}
                       <div class="panel-body">  
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtfromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txttodate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <!-- div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtuserid">User Id</label>
                                    <input type="text" id="txt_userid" name="txt_userid" class="form-control" placeholder="Enter User Id." >
                                </div>
                            </div -->
                            
                           

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-info" type="button">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
                                <th>MEMBER ID [ NAME]</th>
								 <th>PAY DATE</th>
                                <th class="min-tablet">DESCRIPTION</th>
                                <th class="min-tablet">AMOUNT</th>
                                <th class="min-tablet">DEDUCTION</th>
								<th class="min-tablet">STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $sn = 1;?>
								@foreach( $salary_report as $con)
								<tr>
									<td>{{ $sn++ }}</td>
									<td>{{$con->USER_CODE}} [{{ $con->USER_NAME }}]</td>
								    <td>{{ $con->CASHBACK_PAYDATE}}</td>
									<td>{{'CASH BACK'}}</td>
									<td>{{ $con->CASHBACK_AMOUNT}}</td>
									<td>{{ $con->CASHBACK_TDSCHARGE}}</td>
									<td><span class="label label-table label-success">{{ $con->CASHBACK_STATUS }}</span></td>
								</tr>
								@endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection