@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">All Users</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up""></i></button>
                    </div>
                    <h3 class="panel-title">All Member Details</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('/emp_all_user')}}" method="POST">
                        {{ csrf_field() }}
                            <div class="panel-body">

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="control-label">Members</label>
                                        <div class="radio">
                                            <input id="rballmembers" class="magic-radio" type="radio" name="rb_topupst" value="0" 
                                                   <?php echo ($topupst=='ALL')?'checked':''?> >
                                            <label for="rballmembers">All Members</label>

                                            <input id="rbjoinmember" class="magic-radio" type="radio" name="rb_topupst" value="1" 
                                                   <?php echo ($topupst=='NO')?'checked':''?>>
                                            <label for="rbjoinmember">Join Member</label>

                                            <input id="rbtopupmember" class="magic-radio" type="radio" name="rb_topupst" value="2"
                                                   <?php echo ($topupst=='TOPUP')?'checked':''?>
                                                   >
                                            <label for="rbtopupmember">Topup Member</label>
                                        </div>
                                    </div>
                                </div>    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtfromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}"  class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txttodate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" value="{{$end}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtuserid">Member Id</label>
                                        <input type="text" id="txt_userid" name="txt_userid"  value="{{$txt_memberids}}"  class="form-control" placeholder="Enter User Id." >
                                    </div>
                                </div>

                            
                            <!--div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label">Position</label>
                                    <select name="dd_pos" id="dd_pos" class="form-control">
                                        <option value="-1">Select</option>
                                        <option value="LEFT">LEFT</option>
                                        <option VALUE="RIGHT">RIGHT</option>
                                    </select>
                                </div>
                            </div-->

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-success" type="button" onclick="EXPORTTOEXCEL('all_user');">Export To Excel</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBER NAME</th>
								<th>MEMBER ID</th>
								<th>CONTACTNO</th>
								<th>SPONSOR ID</th>
								<th>PARENT ID</th>
								<th>JOINING DATE</th>
								<th>PACKAGE</th>
								<th>STATUS</th>	
							</tr>
						</thead>
						<tbody>
							<?php $sn = 1;$lvl_no="1"; $totalpv=0.00;$totalretopup_pv=0.00;?>
												@if( !empty($user_report))
													@foreach( $user_report as $con)
					@if($topupst=="ALL" && $topupst!="")
															<?php 
																$totalpv=$totalpv+$con->TOPUP_BV;
																$totalretopup_pv=$totalretopup_pv+$con->RETOPUP_BV;
													
																?>
							<tr>
								  <td>{{ $topupst }}</td>
								<td>{{$con->MemberName}}</td>
								<td>{{$con->RegCode}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->PACKAGE_NAME }}</td>
								<td>{{ $con->MemberStatus }}</td>
                            </tr>
									@endif
                                @if($topupst!="" && $topupst=="NO" && $topupst!="ALL" && $con->TOPUP_DATE=="NO")
<?php 
																$totalpv=$totalpv+$con->TOPUP_BV;
																$totalretopup_pv=$totalretopup_pv+$con->RETOPUP_BV;
													
																?>
<tr>
								  <td>{{ $topupst }}</td>
								<td>{{$con->MemberName}}</td>
								<td>{{$con->RegCode}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->PACKAGE_NAME }}</td>
								<td>{{ $con->MemberStatus }}</td>
								
                            </tr>
 @endif
                                @if($topupst!="" && $topupst!="NO" && $topupst!="ALL" && $con->TOPUP_DATE!="NO")
<tr>
								  <td>{{ $topupst }}</td>
								<td>{{$con->MemberName}}</td>
								<td>{{$con->RegCode}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->TOPUP_DATE  }}</td>
								<td>{{ $con->RETOPUP_DATE }}</td>
								<td>{{ $con->PACKAGE_NAME }}</td>
								<td>{{ $con->TOPUP_BV }}</td>
								<td>{{ $con->REPACKAGE_NAME  }}</td>
								<td>{{ $con->RETOPUP_BV }}</td>
								<td>{{ $con->MemberStatus }}</td>
								
                            </tr>
 @endif
							 @endforeach
							@endif
						</tbody>
							</table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection