@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">ADD API HERE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="">
            
                <div class="panel">

					@if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('api_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("api_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">ADD API HERE</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form id="emp_create_api" action="{{url('emp_create_api')}}" method="post">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class=" control-label">API METHOD</label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="rb_api_get" class="magic-radio" type="radio" name="rb_api_method" value="1" required>
                                                <label for="rb_api_get">GET</label>
                                                <input id="rb_api_post" class="magic-radio" type="radio" name="rb_api_method" value="2">
                                                <label for="rb_api_post">POST</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class=" control-label">API TYPE</label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="rb_api_prepaid" class="magic-radio" type="radio" name="rb_api_type" value="1" required>
                                                <label for="rb_api_prepaid">PREPAID</label>
                                                <input id="rb_api_postpaid" class="magic-radio" type="radio" name="rb_api_type" value="4">
                                                <label for="rb_api_postpaid">POSTPAID</label>
                                                <input id="rb_api_billpay" class="magic-radio" type="radio" name="rb_api_type" value="6">
                                                <label for="rb_api_billpay">BILL PAYMENT</label>
                                                <input id="rb_api_dmt" class="magic-radio" type="radio" name="rb_api_type" value="12">
                                                <label for="rb_api_dmt">DMT</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class=" control-label">DATA SEND VIA</label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="rb_query_string" class="magic-radio" type="radio" name="rb_data_send" value="1" required>
                                                <label for="rb_query_string">QUERY STRING</label>
                                                <input id="rb_array" class="magic-radio" type="radio" name="rb_data_send" value="2">
                                                <label for="rb_array">ARRAY</label>
												<input id="rb_form_data" class="magic-radio" type="radio" name="rb_data_send" value="3">
                                                <label for="rb_form_data">FORM DATA</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_api_name">Enter API Name</label>
                                            <input type="text" name="txt_api_name" id="txt_api_name" class="form-control" placeholder="Enter API Name.">
                                        </div>
                                    </div>

                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_trans_url">Transaction URL</label>
                                            <input type="text" name="txt_trans_url" id="txt_trans_url" class="form-control" placeholder="Enter Transaction URL.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_trans_param">Transaction Parameter</label>
                                            <input type="text" name="txt_trans_param" id="txt_trans_param" class="form-control" placeholder="Enter Transaction Parameter.">
                                        </div>
                                    </div>

                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bal_url">Balance URL</label>
                                            <input type="text" name="txt_bal_url" id="txt_bal_url" class="form-control" placeholder="Enter Balance URL.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bal_param">Balance Parameter</label>
                                            <input type="text" name="txt_bal_param" id="txt_bal_param" class="form-control" placeholder="Enter Balance Parameter.">
                                        </div>
                                    </div>

                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_url">Status URL</label>
                                            <input type="text" name="txt_status_url" id="txt_status_url" class="form-control" placeholder="Enter Status URL.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_param">Status Parameter</label>
                                            <input type="text" name="txt_status_param" id="txt_status_param" class="form-control" placeholder="Enter Status Parameter.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_allow_qty">Allow Qty</label>
                                            <input type="text" name="txt_allow_qty" id="txt_allow_qty" class="form-control" placeholder="Enter Allow Qty.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_allow_hlr">Allow HLR</label>
                                            <input type="text" name="txt_allow_hlr" id="txt_allow_hlr" class="form-control" placeholder="Enter Allow HLR.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select class="form-control" name="dd_status" id="dd_status" required>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>


                                <div class="row">

                                    <h3 class="panel-title">API RESPONSE</h3>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_response">Select Response Occurance</label>
                                            <select class="form-control" name="dd_response" id="dd_response" required>
                                                <option value="-1">Select Response Occurance</option>
                                                <option value="1">Instant</option>
                                                <option value="2">Callback</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_type">Type</label>
                                            <select class="form-control" name="dd_type" id="dd_type" required>
                                                <option value="-1">Select Response Type</option>
                                                <option value="1">XML</option>
                                                <option value="2">JSON</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_name">Status Name</label>
                                            <input type="text" name="txt_status_name" id="txt_status_name" class="form-control" placeholder="Enter Status Name.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_res_opr_idname">Response for Operator Id Name</label>
                                            <input type="text" name="txt_res_opr_idname" id="txt_res_opr_idname" class="form-control" placeholder="Enter Response for Operator Id Name.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_success_st">Success Status Value</label>
                                            <input type="text" name="txt_success_st" id="txt_success_st" class="form-control" placeholder="Enter Success Status Value.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_pending_st">Pending Status Value</label>
                                            <input type="text" name="txt_pending_st" id="txt_pending_st" class="form-control" placeholder="Enter Pending Status Value.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_failed_st">Failed Status Value</label>
                                            <input type="text" name="txt_failed_st" id="txt_failed_st" class="form-control" placeholder="Enter Failed Status Value.">
                                        </div>
                                    </div>

                                    

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_res_api_idname">Response for API Unique TRXN ID Name</label>
                                            <input type="text" name="txt_res_api_idname" id="txt_res_api_idname" class="form-control" placeholder="Enter Response for API Unique TRXN ID Name.">
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('emp_create_api')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
            
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">ADD API HERE</h3>
                </div>
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S. NO.</th>
                                <th>API NAME</th>
                                <th>TRANSACTION URL</th>
                                <th>BALANCE URL</th>
                                <th class="min-tablet">STATUS URL</th>
                                <th class="min-tablet">STATUS</th>
                                <th class="min-tablet">CREATED AT</th>
                                <th class="min-tablet">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1;?>
                            @foreach($api as $a)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$a->API_NAME}}</td>
                                <td>{{$a->RECHARGE_URL}}</td>
                                <td>{{$a->BALANCE_URL}}</td>
                                <td>{{$a->API_URL_STATUS}}</td>
                                <td>{{$a->API_STATUS}}</td>
                                <td>{{$a->API_ONADD}}</td>
                                <td><a class="btn btn-success btn-xs" href="{{url('emp_view_api/'.$a->API_ID)}}">EDIT</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection