@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Add Denomination</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Add denomination</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-sm-offset-3 col-sm-6">
            
                <div class="panel">
                    @if(Session::has('massage')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("massage") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">ADD DENOMINATION</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form id="create_api" action="{{url('update-denomination/'.$SingleData[0]->m67_id)}}" method="post">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_denominat">Enter Denominat</label>
                                            <input type="text" name="txt_denominat" id="txt_denominat" value="{{$SingleData[0]->m67_denominat}}" class="form-control @error('txt_denominat') is-invalid @enderror" placeholder="Enter Denominat.">
                                        @error('txt_denominat')
                                            <div class="control-label text-danger">{{ $message }}</div>
                                        @enderror
                                        </div>

                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <textarea name="txt_desc" id="txt_desc" class="form-control @error('txt_desc') is-invalid @enderror" placeholder="Enter Description">{{$SingleData[0]->m67_desc}}</textarea>
                                        @error('txt_desc')
                                            <div class="control-label text-danger">{{ $message }}</div>
                                        @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('create_api')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
            
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">VIEW DENOMINATIONS</h3>
                </div>
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th class="min-tablet">S. NO.</th>
                                <th class="min-tablet">DENOMINATION</th>
                                <th class="min-tablet">DESC</th>
                                <th class="min-tablet">CREATED AT</th>
                                <th class="min-tablet">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data as $key => $value)
                            <tr>
                                <th>{{$key+1}}</th>
                                <th>{{$value->m67_denominat}}</th>
                                <th>{{$value->m67_desc}}</th>
                                <th>{{$value->m67_created_at}}</th>
                                <th><a href="{{url('edit-denomination/'.$value->m67_id)}}" class="btn btn-sm btn-success">Edit</a></th>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection