@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Admin Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">PAYMENT RELEASE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>


    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">

            <div class="col-lg-offset-3 col-lg-6">
            
                <div class="panel">

                     @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">PAYMENT RELEASE REPORT</h3>
                    </div>

                    <div class="collapse in">

                        
        
                         <form action="{{ url('/payment_release') }}" method="post">
                        {{ csrf_field() }}
                           <div class="panel-body">  
                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="col-md-3 control-label" for="txt_memberid">Member Id*</label>
                                        <div class="col-md-9">
                                            <input type="text" name="txt_memberid" id="txt_memberid" class="form-control input-inline input-medium">
                                        </div>
                                    </div>
                                </div>
                               

                            </div>
                           
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            </div>
            
        </div>
        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                   <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                       <thead>
							<tr>
								
								<th>USER ID.</th>
								<th>USER NAME</th>
								<th class="min-tablet">PANCARD  </th>
								<th class="min-tablet">BANK NAME</th>
								<th class="min-tablet">ACCOUNT NO.</th>
								<th class="min-tablet">IFSC</th>
								<th class="min-tablet">FINAL AMOUNT</th>
								<th class="min-tablet">ACTION</th>
							</tr>
                        </thead>
                        <tbody>
						<?php $sn = 1; ?>			
						@if(!empty($payment_release))
							@foreach( $payment_release as $con )	
                                    @if($con->AVAILBALNCE>0.00)	
							<tr>									
							<td>{{ $con->RegCode }}</td>	
							<td>{{ $con->MemberName }}</td>
							<td>{{ $con->PANCARDNO }}</td>
							<td>{{ $con->BANK_NAME }}</td>
							<td>{{ $con->FUNDREQ_ACCOUNTNO }}</td>
							<td>{{ $con->BANK_IFSCODE }}</td>
							<td>{{ $con->AVAILBALNCE}}</td>
                                <th class="min-tablet"><button data-id="{{ $con->RegId }}" data-packname="" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val" onClick="get_details(this);" data-userid="{{ $con->RegCode }}" data-username="{{ $con->MemberName }}" data-finalamt="{{ $con->AVAILBALNCE }}">PAY</button></th>
							</td>
							</tr>
                                @endif	
							@endforeach								
					@endif
                        </tbody>
                    </table>
                </div>
            
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content" style="text-align: left;">

                    <form action="{{url('/pay_payment')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">PAY INCOME HERE</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_payregid" name="txt_payregid" type="hidden" class="form-control" required="required">
                                <input id="txt_payamt" name="txt_payamt" type="hidden" class="form-control" required="required">
                            </div>
                            <h5>USER ID :-<span id="user_id"></span></h5>

                            <h5>USER NAME :-<span id="user_name"></span></h5>

                            <h5>FINAL AMOUNT :-<span id="fnl_amt"></span></h5>

                            <h5>PAY MODE :-</h5>

                            <div class="form-group">
                                <select class="form-control" name="dd_paymode" id="dd_paymode" required>
                                    <option value="-1">SELECT</option>
                                    <option value="4">CASH</option>
                                    <option value="5">NET BANKING</option>
                                    <option value="6">CHEQUE/DRAFT</option>
                                </select>    
                            </div>
                            <h5>REMARKS OR BANK TAX ID :-</h5>

                            <div class="form-group">
                                <input type="text" class="form-control" name="txt_remark" id="txt_remark">  
                            </div>
                            <h5 class="text-semibold text-main">Would you like to pay the amount ?</h5>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var packname = $(this).data('packname');
        $('#txt_statusregid').val(id);
        $('#packname').text(packname);
    });
});

function get_details(obj)
{
    var reg_id = $(obj).data('id');
    var user_id = $(obj).data('userid');
    var user_name = $(obj).data('username');
    var final_amt = $(obj).data('finalamt');
    $('#user_id').text(user_id);
    $('#user_name').text(user_name);
    $('#fnl_amt').text(final_amt);
    $('#txt_payregid').val(reg_id);
    $('#txt_payamt').val(final_amt);
}
</script>
@endsection