@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Admin Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">DIRECT INCOME DETAILS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">GENERATE DIRECT INCOME</h3>
                </div>

                <div class="collapse in">
    
                     <form action="{{ url('generate_levelincome') }}" method="post">
                                    {{ csrf_field() }}
                       <div class="panel-body">  
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtfromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txttodate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>
                           

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">GENERATE</button>
                        </div>
                    </form>
                    
                </div>
    
            </div>
            
        </div>
        @if($direct_report)
        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
                                <th>CLOSING DATE</th>
                                <th>MEMBER </th>
                                <th>BUSINESS BY</th>
                                 <th>LEVEL</th>
                                <th class="min-tablet">DESCRIPTION</th>
                                <th class="min-tablet">AMOUNT</th>
                                <th class="min-tablet">DEDUCTION  (15%)</th>
                                <th class="min-tablet">STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $sn = 1;?>
                                @foreach( $direct_report as $con)
                                <tr>
                                    <td>{{ $sn++ }}</td>
                                    <td>{{ $con->DIRECT_ENTRYDATE}}</td>
                                    <td>{{ $con->DIRECT_USERID }}</td>
                                    <td>{{ $con->REFERRAL_ID }}</td>
                                    <td>{{ $con->DIRECT_LEVEL }}</td>
                                    <td>{{ $con->DIRECT_DESCRIP}}</td>
                                    <td>{{ $con->DIRECT_AMOUNT}}</td>
                                    <td>{{  $con->DIRECT_ADMINCHARGE+$con->DIRECT_TDSCHARGE}} </td>
                                    <td><span class="label label-table label-success">{{ $con->DIRECT_ISPUBLISH }}</span></td>
                                </tr>
                                @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        @endif
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection