@extends('authlayout')
@section('content')	

@if ($errors->any())
<div class="alert alert-danger">
    <ul>
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<div class="cls-content-sm panel">
    <div class="panel-body">
        <div class="mar-ver pad-btm">
            <h1 class="h3">Account Login</h1>
            <p>Sign In to your account</p>
        </div>
        <form action="{{ Request::path() == 'admin_login' ? url('/admin_login') : url('/login') }}" method="POST">
            {{ csrf_field() }}
            <div class="form-group">
                <input type="text" class="form-control" placeholder="Username" name="txt_username" id="txt_username" autofocus>
            </div>
            <div class="form-group">
                <input type="password" class="form-control" placeholder="Password" name="txt_password" id="txt_password">
            </div>
            <div class="checkbox pad-btm text-left">
                <input id="ckbremember" class="magic-checkbox" type="checkbox" name="ckbremember" value="0">
                <label for="ckbremember">Remember me</label>
            </div>
            @if(Request::path() == 'admin_login')
            <input type="hidden" name="ddtype" value="1">
            @else
            <input type="hidden" name="ddtype" value="2">
            @endif
            <button class="btn btn-primary btn-lg btn-block" type="submit">Sign In</button>
        </form>
    </div>

    <div class="pad-all">
        @if(Request::path() == '/login')
        <a href="{{ url('/user/forgot_pass') }}" class="btn-link mar-rgt">Forgot password ?</a>
        <a href="{{ url('/user/register') }}" class="btn-link mar-lft">Create a new account</a>
        @endif
    </div>
</div>
@endsection
