@extends('authlayout')
@section('content')	

@if ($errors->any())
<div class="alert alert-danger">
    <ul>
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<div class="cls-content-sm panel">
    <div class="panel-body">
        <h1 class="h3">Enter OTP</h1>
        <p class="pad-btm">Enter your email address to recover your password. </p>
        <form action="">
            <div class="form-group">
                <input type="text" class="form-control" placeholder="Type your email address" name="txt_username" id="txt_username" autofocus required>
            </div>
            <div class="form-group">
                <input type="email" class="form-control" placeholder="Email">
            </div>
            <div class="form-group text-right">
                <button class="btn btn-danger btn-lg btn-block" type="submit">Reset Password</button>
            </div>
        </form>
        <div class="pad-top">
            <a href="{{url('login')}}" class="btn-link text-bold text-main">Back to Login</a>
        </div>
    </div>
</div>
@endsection