<!DOCTYPE html>
<html lang="en">
<head>
	<title>{{ config('SITE_NAME') }}</title>
<?php $asset = config('CSS_FOLDER'); ?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
<!--===============================================================================================-->	
	<link rel="icon" type="image/png" href="{{asset($asset.'/login_form/images/icons/favicon.ico')}}"/>
<!--===============================================================================================-->
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="{{asset($asset.'/login_form/fonts/font-awesome-4.7.0/css/font-awesome.min.css')}}">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="{{asset($asset.'/login_form/fonts/iconic/css/material-design-iconic-font.min.css')}}">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="{{asset($asset.'/login_form/css/util2.css')}}">
	<link rel="stylesheet" type="text/css" href="{{asset($asset.'/login_form/css/main2.css')}}">
<!--===============================================================================================-->
</head>
<style>
	.focus-input100::after {
    bottom: 10px;
}

@media only screen and (max-width:767px){
.container-login100 {
    padding: 15px 15px 15px 15px;
}}
</style>

<?php

$color = config('SITE_BTN_BG'); // Color Code
$rand_color1 = '#' . substr(md5(mt_rand()), 0, 6);
$rand_color2 = '#' . substr(md5(mt_rand()), 0, 6);
$rand_color3 = '#' . substr(md5(mt_rand()), 0, 6);
 
$opacity = "50"; // Opacity Value (number inside quotation marks), default is 100 (100 is no opacity).

function Qassim_HEX_To_RGBA($color, $opacity = 100){
 
    /*
        Convert HEX Color to RGBA Color, opacity value support.
        Written By: Qassim Hassan
        Twitter: @QQQHZ
        Website: wp-time.com
    */
 
    $color = trim($color, "#");
    $color = trim($color, "#");
 
    $hex = hexdec($color);
 
    if( strlen($color) == 6 ){
        $r = hexdec( substr($color, 0, 2) );
        $g = hexdec( substr($color, 2, 2) );
        $b = hexdec( substr($color, 4, 2) );
 
        if( $opacity > 99){
            $opacity = 1;
        }else{
            $opacity = "0.$opacity";
        }
 
        $a = $opacity;
    }
 
    else{
        return "Error color code! Please enter correct color code, for example #ffffff";
        return false;
    }
 
    return $r.", ".$g.", ".$b.", ".$a;
 
}
 
$form_bg_rgb = Qassim_HEX_To_RGBA($color, $opacity);

?>
  <style>
@media only screen and (max-width:767px){
.container-login100 {
    padding: 15px 15px 15px 15px;
}}
.container-login100::before{
  background : rgba(<?php echo $form_bg_rgb; ?>);
}
.login100-form-bgbtn {
    background: -webkit-linear-gradient(right, {{$color}}, {{$rand_color1}}, {{$rand_color2}}) !important;
  }
</style>
<body>
	
	<div class="limiter">
	 <?php $bg_logo = config('SITE_BG_IMAGE');  ?>
    <div class="container-login100" style="background-image: url('{{asset($asset."/images/config/bg/".$bg_logo)}}');">
			@if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
				</div>
		   @endif
			<div class="wrap-login100 p-l-55 p-r-55 p-t-15 p-b-15">
				<form class="login100-form validate-form" action="{{ url('/sign-up') }}" method="POST">
					{{ csrf_field() }}
					<span class="login100-form-title p-b-20" style="font-size:30px;">
						Sign Up
					</span>

					<div class="wrap-input100 validate-input m-b-15" data-validate = "Referral Code is required">
						
						<input class="input100 height40" type="text" placeholder="Referral Code" name="txt_referralcode" id="txt_referralcode" value="{{$SPONSOR}}" readonly required>
						<span class="focus-input100" data-symbol="&#xf206;"></span>
						@error('txt_referralcode')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>

					<div class="wrap-input100 validate-input m-b-15" data-validate = "Referral Name is required">
						
						<input class="input100 height40" type="text" placeholder="Referral Name" name="txt_referralname" id="txt_referralname"  value="{{$name}}" readonly required>
						<span class="focus-input100" data-symbol="&#xf206;"></span>
					</div>
					
					<div class="wrap-input100 validate-input m-b-15" data-validate = "Full Name is required">
						
						<input class="input100 height40" type="text" placeholder="Type your Full Name" name="txt_username" id="txt_username"   value="{{old('txt_username')}}" >
						<span class="focus-input100" data-symbol="&#xf206;"></span>
                                     @error('txt_username')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>
					
					<div class="wrap-input100 validate-input m-b-15" data-validate="E-mail is required">
						
						<input class="input100 height40" type="email" placeholder="Type your E-mail" name="txt_email" id="txt_email"    value="{{old('txt_email')}}"  required>
						<span class="focus-input100" data-symbol="&#xf190;"></span>
						@error('txt_email')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>
					
					<div class="wrap-input100 validate-input m-b-15" data-validate="Mobile Number is required">
						
						<input class="input100" type="number" placeholder="Type your Mobile Number" name="txt_mobileno" id="txt_mobileno"    value="{{old('txt_mobileno')}}"  required>
						<span class="focus-input100" data-symbol="&#xf190;"></span>
						@error('txt_mobileno')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>

					<div class="wrap-input100 validate-input m-b-15" data-validate="State">						
						<select class="input100" placeholder="Type your Aadhar Number" name="dd_state" id="dd_state"  title="Please enter valid Aadhar Number!" onchange="change_state()" required>
						<option value="">Select State</option>
						@foreach($state as $value)
					     <option value="{{$value->LOC_ID}}" {{old('dd_state') == $value->LOC_ID? 'selected':''}}>{{$value->LOC_NAME}}</option>
						@endforeach
						</select>
						<span class="focus-input100" data-symbol="&#xf190;"></span>
						@error('dd_state')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>
					<div class="wrap-input100 validate-input m-b-15" data-validate="City">
						
					<select class="input100" name="dd_city" id="dd_city" data-live-search="true" data-width="100%">
					                                <option value="" >Select City</option>
					                            </select>
						<span class="focus-input100" data-symbol="&#xf190;"></span>
						@error('dd_city')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>
					
					<!--div class="wrap-input100 validate-input m-b-15" data-validate="Password is required">
						
						<input class="input100 height40" type="password" placeholder="Type your password" name="password" id="password" required>
						<span class="focus-input100" data-symbol="&#xf190;"></span>
						@error('password')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div>
					
					<div class="wrap-input100 validate-input m-b-15" data-validate="Password is required">
						
						<input class="input100 height40" type="password" placeholder="Confirm Password" name="password_confirmation" id="password_confirmation" required>
						<span class="focus-input100" data-symbol="&#xf190;"></span>
						@error('password_confirmation')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					</div-->
					<input type="hidden" name="password" id="password" value="INDIAA">@error('password')<span  style="color: #ea4335; margin-left: 41px;">{{ $message }}</span>@enderror
					<input type="hidden" name="password_confirmation" id="password_confirmation" value="INDIAA">
					<input type="hidden" name="txt_address" id="txt_address" value="INDIA">
					<input type="hidden" name="dd_role" id="dd_role" value="7">
					<input type="hidden" name="dd_service" id="dd_service" value="1">
					<input type="hidden" name="dd_country" id="dd_country" value="1">

					<input type="hidden" name="txt_addressproof" id="txt_addressproof" value="">
					<div class="text-right p-t-8 p-b-20">
						<a href="#">
							Forgot password?
						</a>
					</div>
					
					<div class="container-login100-form-btn">
						<div class="wrap-login100-form-btn">
							<div class="login100-form-bgbtn"></div>
							<button class="login100-form-btn">
								Register
							</button>
						</div>
					</div>

					<div class="txt1 text-center p-t-5">
						<span>
							<a class="txt1" href="{{ url('/login') }}">
							Already have an account ? SIGN IN
							<i class="fa fa-long-arrow-right"></i>						
						</a>

						</span>
					</div>


					<div class="flex-col-c p-t-5">
						

						<a href="{{ url('/') }}" class="txt2">
							Back To Homepage
						</a>
					</div>
				</form>
			</div>
		</div>
	</div>
	

	<div id="dropDownSelect1"></div>
<script	src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script type="text/javascript">

function get_member_name_signup()
{
var introducer = $('#txt_referralcode').val();
var csrf = $("input[name='csrf_token']").val();
if($("#txt_referralcode").val()!="")
{
$.ajax({	
type:"POST",
url:"{{ url('/getMemberName') }}",
dataType: 'json',
data:{"txtintuserid":introducer, _token: '{{csrf_token()}}'},
beforeSend : function(){
$('img.loader').show('fadein');
},
success:function(msg) 
{
console.log(msg);
$('img.loader').hide('fadeout');
$('#txt_referralname').val(msg.name);
}
});
}
}


        function change_state() {
        var id = $("#dd_state").val();

        if(id > 0)
        {
            $.ajax({
               type:"POST",
               url:"{{ url('/get-city')}}",
               data:{"_token": "{{ csrf_token() }}", "id":id },
               success:function(result)
               {   
                    if(result == 'DATA NOT FOUND')
                    {
                        alert(result);
                    }
                    else
                    {
                        $('#dd_city').empty();
                        $("#dd_city").append('<option value="">Select City</option>');
                        $.each(result,function(key,value){
                            $("#dd_city").append('<option value="'+result[key].LOC_ID+'" >'+result[key].LOC_NAME+'</option>');
                        });
                        $('.selectpicker').selectpicker('refresh');
                    }    
               }
            });}
        }

window.onload = (event) => {
change_state();
console.log('page is fully loaded');
};
</script>

</body>
</html>