<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <meta name="description" content="{{ config('SITE_NAME') }}">
      <meta name="author" content="{{ config('SITE_NAME') }}">
      <link rel="shortcut icon" type="image/png" href="{{asset('/images/config/logo/'.config('SITE_LOGO'))}}">
      <title>{{ config('SITE_NAME') }}</title>
      <!-- Bootstrap core CSS -->
      <link href="{{asset('auth/vendor/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet">
      <!-- Custom styles for this template -->
      <link href="{{asset('auth/css/auth.css')}}" rel="stylesheet">
      <!-- Font -->
      <link rel="preconnect" href="https://fonts.gstatic.com">
      <script src="https://kit.fontawesome.com/cc527ccbca.js" crossorigin="anonymous"></script>
      <link href="https://fonts.googleapis.com/css2?family=Rubik&display=swap" rel="stylesheet">
      <link href="{{asset('auth/css/select2.min.css')}}" rel="stylesheet" />
      <style>
         /* Chrome, Safari, Edge, Opera */
         input::-webkit-outer-spin-button,
         input::-webkit-inner-spin-button {
           -webkit-appearance: none;
           margin: 0;
         }

         /* Firefox */
         input[type=number] {
           -moz-appearance: textfield;
         }
        .logsec{   
             background-image: url('{{asset("images/etha.jpg")}}');
           background-color:#000;
             background-repeat: no-repeat;
             background-size: cover;
           background-position:center;
             padding: 50px 0px;
           height:100vh;
           max-height:100%;
           display: flex;
           align-items: center;  
           }
         .logform {
            box-shadow: rgb(125 79 18 / 65%) 10px 10px 5px;
            background: #fff;
            border-radius: 1.5rem;
         }
         </style>
   </head>
   <body class="logsec">
   <div class="container">
         <div class="row justify-content-center">
					   <div class="col-xl-7 col-lg-8 col-md-9 col-sm-10 align-self-center">
						 <div class="my40 logform p-md-5 p-3">
					 <p class="mb-0 text-center">
                        <a href="{{url('/')}}" class="intro-x d-flex items-center justify-content-center text-center">
                        <img alt="logo" src="{{asset('/images/config/logo/'.config('SITE_LOGO'))}}" width="100">
                        </a>
                     </p>
                     <h3 class="mb-2 text-primary">Sign Up</h3>
                           @if(Session::has('message')) 
                              <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                                 <h6 class="alert-heading">{{ Session::get("message") }}</h6>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                       <span aria-hidden="true">&times;</span>
                                    </button>
                              </div>
                           @endif
                           @if ($errors->any())
                               <div class="alert alert-danger">
                                   <ul>
                                       @foreach ($errors->all() as $error)
                                           <li>{{ $error }}</li>
                                       @endforeach
                                   </ul>
                               </div>
                           @endif
                     <!-- <form class="row" action="{{ url('/sign-up') }}" method="POST"> -->
                     <form class="row" action="{{ url('/sign-up-verification') }}" method="POST">
                        {{ csrf_field() }}
                        <div class="input-group mb-3 form-group col-md-12">
                           <input type="text" class="form-control border-right-0 rounded-right-0" placeholder="Referral Code" name="txt_referralcode" id="txt_referralcode" value="{{$SPONSOR}}" oninput="get_member_name_signup()" >
                           <div class="input-group-prepend">
                              <span class="input-group-text bg-white border-left-0 form-control rounded-left-0" id="basic-addon4">-{{$name}}</span>
                           </div>
                           <span class="text-danger" id="divtxt_fname"></span>
                           @error('txt_referralcode')<span class="text-danger">{{ $message }}</span>@enderror
                        </div>
                        <div class="form-group col-md-6">
                           <input type="text" class="form-control" placeholder="Enter your Full Name" name="txt_username" id="txt_username"   value="{{old('txt_username')}}">
                           <span class="text-danger" id="divtxt_lname"></span>
                           @error('txt_username')<span class="text-danger">{{ $message }}</span>@enderror
                        </div>
                        <div class="form-group col-md-6">
                           <input type="email" class="form-control" placeholder="Enter your E-mail" name="txt_email" id="txt_email" value="{{old('txt_email')}}" required>
                           <span class="text-danger" id="divtxt_email"></span>
                           @error('txt_email')<span class="text-danger">{{ $message }}</span>@enderror      
                        </div>
                        <div class="form-group col-md-6">
                           <input type="number" class="form-control" placeholder="Enter your Mobile Number" name="txt_mobileno" id="txt_mobileno" value="{{old('txt_mobileno')}}" required>
                           <span class="text-danger" id="divtxt_email"></span>
                           @error('txt_mobileno')<span class="text-danger">{{ $message }}</span>@enderror      
                        </div>


                        <div class="form-group col-md-6">

                            <select class="form-control js-example-basic-single" id="dd_country" name="dd_country" data-live-search="true" data-width="100%">
                                <option value="">Select Country</option>
                                @foreach($data['country'] as $value)
                                <option value="{{$value->LOC_ID}}" {{old('dd_country') == $value->LOC_ID}}>{{$value->LOC_NAME}}</option>
                                @endforeach
                            </select> 
                              <span class="text-danger" id="divdd_country"></span>
                              @error('dd_country')<span class="text-danger">{{ $message }}</span>@enderror   
                        </div>


                        <div class="input-group mb-0 form-group col-md-6" id="show_hide_password">
                           <input type="password" class="form-control border-right-0 rounded-right-0" name="txt_password" id="txt_password" placeholder="Enter your Password" required autocomplete="false">
                           <div class="input-group-prepend">
                              <span class="input-group-text bg-white border-left-0 form-control rounded-left-0" id="basic-addon1"><a><i class="fa fa-eye-slash text-secondary" aria-hidden="true"></i></a></span>
                           </div>
                        </div>
                        <span class="text-danger" id="divtxt_password"></span>
                        @error('txt_password')<span class="text-danger">{{ $message }}</span>@enderror 

                        <div class="input-group mb-0 form-group col-md-6" id="show_hide_cpassword">
                           <input type="password" class="form-control border-right-0 rounded-right-0" name="txt_password_confirmation" id="txt_password_confirmation" placeholder="Enter Confirm Password" required autocomplete="false">
                           <div class="input-group-prepend">
                              <span class="input-group-text bg-white border-left-0 form-control rounded-left-0" id="basic-addon2"><a><i class="fa fa-eye-slash text-secondary" aria-hidden="true"></i></a></span>
                           </div>
                        </div>
                           <span class="text-danger" id="divtxt_password_confirmation"></span>
                           @error('confirmed')<span class="text-danger">{{ $message }}</span>@enderror 


                        <div class="mt-3 form-group col-md-12">
                           <input id="terms" class="magic-checkbox empty" type="checkbox" name="ckbterms" value="0" required checked>
                           <label for="ref_id" class=" text-primary">I agree to the {{ config('SITE_NAME') }}<a href="#" class=""> Privacy Policy</a></label>
                        </div>
                  

                
                           <input type="hidden" name="txt_referralname" id="txt_referralname" value="{{$name}}">
                           <input type="hidden" name="txt_address" id="txt_address" value="INDIA">
                           <input type="hidden" name="dd_role" id="dd_role" value="8">
                           <input type="hidden" name="dd_state" id="dd_state" value="1">
                           <input type="hidden" name="dd_city" id="dd_city" value="1">
                           <!-- <input type="hidden" name="dd_country" id="dd_country" value="1"> -->
                           <input type="hidden" name="dd_position" id="dd_position" value="LEFT">

                     <div class="col-md-12">
                        <button class="btn btn-info w-32 mr-2 mb-2 " type="submit">Register</button>
                        <a class="btn btn-info w-32 mr-2 mb-2 " href="{{url('login')}}">Sign in</a>
                     </div>
                     </form>
                     <div class="mt-3">
                        <p class="mb-0 text-primary">By signin up, you agree to our <a href="#">Terms and Conditions</a> & <a href="#">Privacy Policy</a></p>
                     </div>
						  </div>
					   </div>
         </div>
      </div>
      
      <!-- /#wrapper -->
      <!-- Bootstrap core JavaScript -->
      <script src="{{asset('auth/vendor/jquery/jquery.min.js')}}"></script>
      <script  src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
      <script src="{{asset('auth/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>

      <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
      <script type="text/javascript">
         $(document).ready(function() {
         $('.js-example-basic-single').select2();
          $("#show_hide_password a").on('click', function(event) {
            event.preventDefault();
            if($('#show_hide_password input').attr("type") == "text"){
              $('#show_hide_password input').attr('type', 'password');
              $('#show_hide_password i').addClass( "fa-eye-slash" );
              $('#show_hide_password i').removeClass( "fa-eye" );
            }
            else if($('#show_hide_password input').attr("type") == "password"){
              $('#show_hide_password input').attr('type', 'text');
              $('#show_hide_password i').removeClass( "fa-eye-slash" );
              $('#show_hide_password i').addClass( "fa-eye" );
            }
          });

          $("#show_hide_cpassword a").on('click', function(event) {
            event.preventDefault();
            if($('#show_hide_cpassword input').attr("type") == "text"){
              $('#show_hide_cpassword input').attr('type', 'password');
              $('#show_hide_cpassword i').addClass( "fa-eye-slash" );
              $('#show_hide_cpassword i').removeClass( "fa-eye" );
            }
            else if($('#show_hide_cpassword input').attr("type") == "password"){
              $('#show_hide_cpassword input').attr('type', 'text');
              $('#show_hide_cpassword i').removeClass( "fa-eye-slash" );
              $('#show_hide_cpassword i').addClass( "fa-eye" );
            }
          });
         });
            
      </script>

<script type="text/javascript">

   function get_member_name_signup()
   {
      var introducer = $('#txt_referralcode').val();
      var csrf = $("input[name='csrf_token']").val();

      if($("#txt_referralcode").val()!="" && $("#txt_referralcode").val().length > 3)
      { 
         
         $.ajax({ 
            type:"POST",
            url:"{{ url('/getMemberName') }}",
            dataType: 'json',
            data:{"txtintuserid":introducer, _token: '{{csrf_token()}}'},
            beforeSend : function(){
               $('img.loader').show('fadein');
            },
            success:function(msg) 
            {
               console.log(msg);
               $('img.loader').hide('fadeout');
               $('#basic-addon4').text('-'+msg.name);
               //$('#txt_referralname').val(msg.name);
            }
         });
      }
   }


     function change_state() {
     var id = $("#dd_state").val();

     if(id > 0)
     {
         $.ajax({
            type:"POST",
            url:"{{ url('/get-city')}}",
            data:{"_token": "{{ csrf_token() }}", "id":id },
            success:function(result)
            {   
                 if(result == 'DATA NOT FOUND')
                 {
                     alert(result);
                 }
                 else
                 {
                     $('#dd_city').empty();
                     $("#dd_city").append('<option value="">Select City</option>');
                     $.each(result,function(key,value){
                         $("#dd_city").append('<option value="'+result[key].LOC_ID+'" >'+result[key].LOC_NAME+'</option>');
                     });
                     //$('.selectpicker').selectpicker('refresh');
                 }    
            }
         });}
     }

   window.onload = (event) => {
   change_state();
   console.log('page is fully loaded');
   };


</script>
   </body>
</html>