<!DOCTYPE html>
<html lang="en">
<head>
  <title>{{ config('SITE_NAME') }}</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
<!--===============================================================================================-->  
  <link rel="icon" type="image/png" href="{{asset(config('CSS_FOLDER').'/login_form/images/icons/favicon.ico')}}"/>
<!--===============================================================================================-->
<!--===============================================================================================-->
  <link rel="stylesheet" type="text/css" href="{{asset(config('CSS_FOLDER').'/login_form/fonts/font-awesome-4.7.0/css/font-awesome.min.css')}}">
<!--===============================================================================================-->
  <link rel="stylesheet" type="text/css" href="{{asset(config('CSS_FOLDER').'/login_form/fonts/iconic/css/material-design-iconic-font.min.css')}}">
<!--===============================================================================================-->
  <link rel="stylesheet" type="text/css" href="{{asset(config('CSS_FOLDER').'/login_form/css/util2.css')}}">
  <link rel="stylesheet" type="text/css" href="{{asset(config('CSS_FOLDER').'/login_form/css/main2.css')}}">
<!--===============================================================================================-->



<?php

$color = config('SITE_BTN_BG'); // Color Code
$rand_color1 = '#' . substr(md5(mt_rand()), 0, 6);
$rand_color2 = '#' . substr(md5(mt_rand()), 0, 6);
$rand_color3 = '#' . substr(md5(mt_rand()), 0, 6);
 
$opacity = "50"; // Opacity Value (number inside quotation marks), default is 100 (100 is no opacity).

function Qassim_HEX_To_RGBA($color, $opacity = 100){
 
    /*
        Convert HEX Color to RGBA Color, opacity value support.
        Written By: Qassim Hassan
        Twitter: @QQQHZ
        Website: wp-time.com
    */
 
    $color = trim($color, "#");
    $color = trim($color, "#");
 
    $hex = hexdec($color);
 
    if( strlen($color) == 6 ){
        $r = hexdec( substr($color, 0, 2) );
        $g = hexdec( substr($color, 2, 2) );
        $b = hexdec( substr($color, 4, 2) );
 
        if( $opacity > 99){
            $opacity = 1;
        }else{
            $opacity = "0.$opacity";
        }
 
        $a = $opacity;
    }
 
    else{
        return "Error color code! Please enter correct color code, for example #ffffff";
        return false;
    }
 
    return $r.", ".$g.", ".$b.", ".$a;
 
}
 
$form_bg_rgb = Qassim_HEX_To_RGBA($color, $opacity);

?>
  <style>
@media only screen and (max-width:767px){
.container-login100 {
    padding: 15px 15px 15px 15px;
}}
.container-login100::before{
  background : rgba(<?php echo $form_bg_rgb; ?>);
}
.login100-form-bgbtn {
    background: -webkit-linear-gradient(right, {{$color}}, {{$rand_color1}}, {{$rand_color2}}) !important;
  }
</style>

</head>
<body>
    
    <div class="limiter">
       <?php $bg_logo = config('SITE_BG_IMAGE');  ?>
    <div class="container-login100" style="background-image: url('{{asset("images/config/bg/".$bg_logo)}}');">
      <div class="wrap-login100 p-l-55 p-r-55 p-t-55 p-b-45">
				@if(Session::has('message')) 
                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                    <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
				@endif
                <form class="login100-form validate-form" action="{{ url('/top_verification') }}" method="POST">
                    {{ csrf_field() }}
                    <span class="login100-form-title p-b-20" style="font-size:30px;">
                        Enter OTP
                    </span>

                    <div class="wrap-input100 validate-input m-b-15" data-validate = "Referral Code is required">
                        
                        <input class="input100" type="text" name="txt_otp" id="txt_otp" placeholder="Enter OTP">
                        <span class="focus-input100" data-symbol="&#xf206;"></span>
                    </div>

                    @if(Session::has('count'))
                    <div class="form-group">
                        <a class="txt1"> Attempts Left {{4-Session::get('count')}}</a> 
                    </div>
                    @endif
                    
                    <div class="container-login100-form-btn">
                        <div class="wrap-login100-form-btn">
                            <div class="login100-form-bgbtn"></div>
                            <button class="login100-form-btn">
                                Verify OTP
                            </button>
                        </div>
                    </div>

                    <div class="txt1 text-center p-t-5">
                        <span>
                            <a class="txt1" href="{{ url('/login') }}">
                            Sign In
                            <i class="fa fa-long-arrow-right"></i>                      
                        </a>

                        </span>
                    </div>


                    <div class="flex-col-c p-t-5">
                        

                        <a href="{{ url('/') }}" class="txt2">
                            Back To Homepage
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

</body>
</html>