@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Add API Operator</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin/admin_dashboard') }}">API</a></li>
        <li class="active">Add API Operator</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

					@if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('apiopt_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("apiopt_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Add API Operator Here</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="{{url('api_operator')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_api_provider">Select Api Provider</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_api_provider" id="dd_api_provider" required>
                                                <option value="-1">SELECT API PROVIDER</option>
                                                @foreach($API as $api)
                                                <option value="{{ $api->API_ID }}">{{$api->API_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit" >Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
            
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Add API Operator Here <span class="pull-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('addapi_operator');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></span></h3>
                </div>
				<div class="col-md-12 mb-10">
						@if( Session::get('USER_ID') == -1 )
                
						<button type="button" id="activate_all" class="btn btn-success pull-left" data-toggle="tooltip" data-placement="bottom" title="UPDATE ALL" data-original-title="UPDATE ALL">UPDATE ALL</button>
						@endif
				</div>
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
								<th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                <th>S NO.</th>
                                <th>SERVICE TYPE</th>
                                <th class="min-tablet">TELECOM OPERATOR</th>
                                <th class="min-tablet">SELFCODE</th>
                                <th class="min-tablet">APICODE</th>
                                <th class="min-tablet">COMMISSION</th>
                                <th class="min-tablet">ALLOW QTY</th>
                                <th class="min-tablet">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $sn =  1; ?>
            @foreach( $OPERATOR as $OPT)
           <form id="apiOperator{{$OPT->SPID}}" action="{{url('update_apioperator/'.$OPT->SPID)}}" method="post">
				<div id="{{$OPT->SPID}}">
					{{ csrf_field() }} 
<input id="dd_api" name="dd_api" type="hidden" class="form-control" required="required" value="{{$apiid}}" readonly >
				<tr>
				<td><input type="checkbox" name="activate" value="{{$OPT->SPID}}" /></td>
				<td>{{$sn}}</td>
				<td>{{$OPT->SERVICENAME}}</td>
				<td>{{$OPT->BRANDNAME}}</td>
				<td>{{$OPT->BRANDCODE}}</td>
				<td><div class="col-md-12 col-sm-12 col-xs-12" >
                      <div class="form-group">
                        <input id="txt_apiopcode{{$OPT->SPID}}" name="txt_apiopcode{{$OPT->SPID}}" type="text" class="form-control" required="required" value="{{$OPT->SPCODE}}">
                            <span id="divtxt_apiopcode{{$OPT->SPID}}" style="color:red;"></span> 
                      </div>
                    </div></td>
					<td><div class="col-md-12 col-sm-12 col-xs-12" >
                      <div class="form-group">
 
                        <input id="txt_apicomm{{$OPT->SPID}}" name="txt_apicomm{{$OPT->SPID}}" type="text" class="form-control"  value="{{$OPT->COMMISSION}}">
                            <span id="divtxt_apicomm{{$OPT->SPID}}" style="color:red;"></span> 
                      </div>
                    </div></td>
					<td><div class="col-md-12 col-sm-12 col-xs-12" >
                      <div class="form-group">
 
                        <input id="txt_apiallow_qty{{$OPT->SPID}}" name="txt_apiallow_qty{{$OPT->SPID}}" type="text" class="form-control"  value="{{$OPT->ALLOW_QTY}}">
                            <span id="divtxt_apiallow_qty{{$OPT->SPID}}" style="color:red;"></span> 
                      </div>
                    </div></td>
                    
					 <td><button type="button" class="btn btn-primary btn-md" onClick="conwv('apiOperator{{$OPT->SPID}}')">UPDATE</button>
                    </td>
                   <td></td>
				</tr>
				 </div>
				</form>
				<?php $sn =  $sn+1; ?>
				
			  @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });

    $('#activate_all').click(function(){
		bootbox.confirm('Are you sure to Submit from?', function(result){
			if((result==true))
			{
				var ids = '';
				var id = new Array();
				var apiCode = new Array();
				var comm = new Array();
				var qty = new Array();
				$("input[name='activate']:checked").each(function(){
				if($(this).val()>0)
				ids = $(this).val();
				id.push($(this).val());
				apiCode.push($('#txt_apiopcode'+ids).val());
				comm.push($('#txt_apicomm'+ids).val());
				qty.push($('#txt_apiallow_qty'+ids).val());
				});
				if(id.length > 0)
				{
				$.ajax({    
					type:"POST",
					url:"{{ url('/update_all_api') }}",
					dataType: 'json',
					data:{"ids":id,"apiCodes":apiCode,"comms":comm,"qtys":qty,_token: '{{csrf_token()}}',_method: "POST"},
					success: function(response){
						   alert("API OPERATOR UPDATED SUCCESSFULLY!");
							window.location.reload(); 
					},
					error: function( req, status, err ) {
						console.log( 'something went wrong', status, err );
						alert(err);
					}
					}); 
				}
				else
				{
					alert("Please select user for changing the status.");
				}
				}
		}); 
    });
</script>
@endsection