@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Add API</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">API</a></li>
        <li class="active">Add API</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="">
            
                <div class="panel">

					@if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('api_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("api_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Add API Here</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form id="create_api" action="{{url('create_api')}}" method="post">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

									

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class=" control-label">API Method <span class="text-danger"> * <span></label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="rb_api_get" class="magic-radio empty" type="radio" name="rb_api_method" value="1" required>
                                                <label for="rb_api_get">GET</label>
                                                <input id="rb_api_post" class="magic-radio" type="radio" name="rb_api_method" value="2">
                                                <label for="rb_api_post">POST</label>
                                            </div>
											<span class="text-danger" id="divrb_api_get"></span>
											<span class="text-danger" id="divrb_api_post"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class=" control-label">API Type <span class="text-danger"> * <span></label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="rb_api_prepaid" class="magic-radio empty" type="radio" name="rb_api_type" value="1" required>
                                                <label for="rb_api_prepaid">Prepaid</label>
                                                <input id="rb_api_postpaid" class="magic-radio" type="radio" name="rb_api_type" value="4">
                                                <label for="rb_api_postpaid">Postpaid</label>
                                                <input id="rb_api_billpay" class="magic-radio" type="radio" name="rb_api_type" value="6">
                                                <label for="rb_api_billpay">Bill Payment</label>
                                                <input id="rb_api_dmt" class="magic-radio" type="radio" name="rb_api_type" value="12">
                                                <label for="rb_api_dmt">DMT</label>
                                            </div>
											<span class="text-danger" id="divrb_api_prepaid"></span>
											<span class="text-danger" id="divrb_api_postpaid"></span>
											<span class="text-danger" id="divrb_api_billpay"></span>
											<span class="text-danger" id="divrb_api_dmt"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class=" control-label">Data Send Via <span class="text-danger"> * <span></label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="rb_query_string" class="magic-radio empty" type="radio" name="rb_data_send" value="1" required>
                                                <label for="rb_query_string">Query String</label>
                                                <input id="rb_array" class="magic-radio" type="radio" name="rb_data_send" value="2">
                                                <label for="rb_array">Array</label>
												<input id="rb_form_data" class="magic-radio" type="radio" name="rb_data_send" value="3">
                                                <label for="rb_form_data">Form Data</label>
                                            </div>
											<span class="text-danger" id="divrb_query_string"></span>
											<span class="text-danger" id="divrb_array"></span>
											<span class="text-danger" id="divrb_form_data"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_api_name">Enter API Name <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_api_name" id="txt_api_name" class="form-control empty" placeholder="Enter API Name.">
											<span class="text-danger" id="divtxt_api_name"></span>
                                        </div>
                                    </div>
		

									<div class="col-sm-12">
                                        <div class="form-group" >
                                            <label class=" control-label" >@apitoken=[API TOKEN]</label>
											<label class=" control-label">@password=[LOGIN PASSWORD]</label>
											<label class=" control-label">@operatorcode=[OPERATOR CODE]</label>
											<label class=" control-label">@amount=[AMOUNT]</label>
											<label class=" control-label">@account=[MOBILE NO]</label>
											<label class=" control-label">@refrence=[YOUR TRANSACTION ID]</label>
											<label class=" control-label">@format=[FORMAT]</label>
											<label class=" control-label">@param1=[PARAM1]</label>
											<label class=" control-label">@param2=[PARAM2]</label>
										</div>
									</div>

                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_trans_url">Transaction URL <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_trans_url" id="txt_trans_url" class="form-control empty" placeholder="Enter Transaction URL.">
											<span class="text-danger" id="divtxt_trans_url"></span>
                                        </div>
                                    </div>

							

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_trans_param">Transaction Parameter </label>
                                            <input type="text" name="txt_trans_param" id="txt_trans_param" class="form-control" placeholder="Enter Transaction Parameter.">
											<span class="text-danger" id="divtxt_trans_param"></span>                                      
									 </div>
                                    </div>

                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bal_url">Balance URL <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_bal_url" id="txt_bal_url" class="form-control empty" placeholder="Enter Balance URL.">
											<span class="text-danger" id="divtxt_bal_url"></span>   
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bal_param">Balance Parameter</label>
                                            <input type="text" name="txt_bal_param" id="txt_bal_param" class="form-control" placeholder="Enter Balance Parameter.">
											<span class="text-danger" id="divtxt_bal_url"></span>   
                                        </div>
                                    </div>

                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_url">Status URL <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_status_url" id="txt_status_url empty" class="form-control" placeholder="Enter Status URL.">
											<span class="text-danger" id="divtxt_status_url"></span>  
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_param">Status Parameter</label>
                                            <input type="text" name="txt_status_param" id="txt_status_param" class="form-control" placeholder="Enter Status Parameter.">
											<span class="text-danger" id="divtxt_status_param"></span>  
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_allow_qty">Allow Qty </label>
                                            <input type="text" name="txt_allow_qty" id="txt_allow_qty" class="form-control" placeholder="Enter Allow Qty.">
											<span class="text-danger" id="divtxt_allow_qty"></span>  
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_allow_hlr">Allow HLR</label>
                                            <input type="text" name="txt_allow_hlr" id="txt_allow_hlr" class="form-control" placeholder="Enter Allow HLR.">
											<span class="text-danger" id="divtxt_allow_hlr"></span>  
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status <span class="text-danger"> * <span></label>
                                            <select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_status" id="dd_status" required>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>
											<span class="text-danger" id="divdd_status"></span>
                                        </div>
                                    </div>

                                </div>


                                <div class="row">
                                    <h3 class="panel-title">Instant API Response </h3>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_response">Select Response Occurance <span class="text-danger"> * <span></label>
                                            <select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_response" id="dd_response" required>
                                                <option value="1" selected>Instant</option>
                                            </select>
											<span class="text-danger" id="divdd_response"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_type">Type <span class="text-danger"> * <span></label>
                                            <select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_type" id="dd_type" required>
                                                <option value="-1">Select Response Type</option>
                                                <option value="1">XML</option>
                                                <option value="2">JSON</option>
                                            </select>
											<span class="text-danger" id="divdd_type"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_name">Status Name <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_status_name" id="txt_status_name" class="form-control empty" placeholder="Enter Status Name.">
											<span class="text-danger" id="divtxt_status_name"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_res_opr_idname">Response for Operator Id Name <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_res_opr_idname" id="txt_res_opr_idname" class="form-control empty" placeholder="Enter Response for Operator Id Name.">
											<span class="text-danger" id="divtxt_res_opr_idname"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_success_st">Success Status Value <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_success_st" id="txt_success_st" class="form-control empty" placeholder="Enter Success Status Value.">
											<span class="text-danger" id="divtxt_success_st"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_pending_st">Pending Status Value <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_pending_st" id="txt_pending_st" class="form-control empty" placeholder="Enter Pending Status Value.">
											<span class="text-danger" id="divtxt_pending_st"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_failed_st">Failed Status Value <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_failed_st" id="txt_failed_st" class="form-control empty" placeholder="Enter Failed Status Value.">
											<span class="text-danger" id="divtxt_failed_st"></span>
                                        </div>
                                    </div>

                                    

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_res_api_idname">Response for API Unique TRXN ID Name</label>
                                            <input type="text" name="txt_res_api_idname" id="txt_res_api_idname" class="form-control" placeholder="Enter Response for API Unique TRXN ID Name.">
                                        </div>
                                    </div>

                                </div>


                             <div class="row">
                                    <h3 class="panel-title">Callback API Response</h3>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_response">Select Response Occurance <span class="text-danger"> * <span></label>
                                            <select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_callback_response" id="dd_callback_response" required>
                                                <option value="2" selected>Callback</option>
                                            </select>
											<span class="text-danger" id="divdd_callback_response"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_type">Type <span class="text-danger"> * <span></label>
                                            <select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_callback_type" id="dd_callback_type" required>
                                                <option value="-1">Select Response Type</option>
                                                <option value="1">XML</option>
                                                <option value="2">JSON</option>
												<option value="3">QUERY STRING</option>
                                            </select>
											<span class="text-danger" id="divdd_callback_type"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_status_name">Status Name <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_callback_status_name" id="txt_callback_status_name" class="form-control empty" placeholder="Enter Status Name.">
											<span class="text-danger" id="divtxt_callback_status_name"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_res_opr_idname">Response for Operator Id Name <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_res_opr_idname" id="txt_res_opr_idname" class="form-control empty" placeholder="Enter Response for Operator Id Name.">
											<span class="text-danger" id="divtxt_res_opr_idname"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_success_st">Success Status Value <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_callback_success_st" id="txt_callback_success_st" class="form-control empty" placeholder="Enter Success Status Value.">
											<span class="text-danger" id="divtxt_callback_success_st"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_pending_st">Pending Status Value</label>
                                            <input type="text" name="txt_callback_pending_st" id="txt_callback_pending_st" class="form-control" placeholder="Enter Pending Status Value.">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_failed_st">Failed Status Value <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_callback_failed_st" id="txt_callback_failed_st" class="form-control empty"  placeholder="Enter Failed Status Value.">
											<span class="text-danger" id="divtxt_callback_failed_st"></span>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_res_api_idname">Response for API Unique TXN ID Name <span class="text-danger"> * <span></label>
                                            <input type="text" name="txt_callback_res_api_idname" id="txt_callback_res_api_idname" class="form-control empty" placeholder="Enter Response for API Unique TRXN ID Name.">
											<span class="text-danger" id="divtxt_callback_res_api_idname"></span>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conw_v('create_api')">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
            
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Add API Here</h3>
                </div>
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S. NO.</th>
                                <th class="min-tablet">API NAME</th>
                                <th>TRANSACTION URL</th>
                                <th>BALANCE URL</th>
                                <th>STATUS URL</th>
								<th>CALLBACK URL</th>
                                <th class="min-tablet">STATUS</th>
                                <th>CREATED AT</th>
                                <th class="min-tablet">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1;?>
                            @foreach($api as $a)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$a->API_NAME}}</td>
                                <td>{{$a->RECHARGE_URL}}</td>
                                <td>{{$a->BALANCE_URL}}</td>
                                <td>{{$a->STATUS_URL}}</td>
								 <td>{{$a->CALLBACK_URL}}</td>
                                <td>{{$a->API_STATUS}}</td>
                                <td>{{$a->API_ONADD}}</td>
                                <td><a class="btn btn-success btn-xs" href="{{url('view_api/'.$a->API_ID)}}">EDIT</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection