/*
 * ===========================================================
 * PROGRESS BAR - CIRCLE PROGRESS BAR - COUNTER - COUNTDOWN - FRAMEWORK Y
 * ===========================================================
 * This script manage the following component: progress bar, circle progress bar, counter and countdown.
 * Documentation: www.framework-y.com/components/components.html#counter
 * Documentation: www.framework-y.com/components/components.html#countdown
 * Documentation: www.framework-y.com/components/components.html#progress-bar
 * 
 * Schiocco - Copyright (c) Federico Schiocchet - Schiocco - Framework Y
 * 
 * jquery-countTo
 * Copyright (c) 2012-2014 Matt Huggins - The MIT License
 * URL: https://github.com/mhuggins/jquery-countTo/
 *
 * jquery-circle-progress - jQuery Plugin to draw animated circular progress bars:
 * {@link http://kottenator.github.io/jquery-circle-progress/}
 *
 * @author Rostyslav Bryzgunov <kottenator@gmail.com>
 * @version 1.2.2
 * @licence MIT
 * @preserve
 *
 * downCount: Simple Countdown clock with offset
 * Author: Sonny T. <hi@sonnyt.com>, sonnyt.com
 */
"use strict"; !function (t) { function i(t, i) { return t.toFixed(i.decimals) } var e = function (i, s) { this.$element = t(i), this.options = t.extend({}, e.DEFAULTS, this.dataOptions(), s), this.init() }; e.DEFAULTS = { from: 0, to: 0, speed: 1e3, refreshInterval: 100, decimals: 0, formatter: i, onUpdate: null, onComplete: null }, e.prototype.init = function () { this.value = this.options.from, this.loops = Math.ceil(this.options.speed / this.options.refreshInterval), this.loopCount = 0, this.increment = (this.options.to - this.options.from) / this.loops }, e.prototype.dataOptions = function () { var t, i, e = { from: this.$element.data("from"), to: this.$element.data("to"), speed: this.$element.data("speed"), refreshInterval: this.$element.data("refresh-interval"), decimals: this.$element.data("decimals") }, s = Object.keys(e); for (t in s) i = s[t], "undefined" == typeof e[i] && delete e[i]; return e }, e.prototype.update = function () { this.value += this.increment, this.loopCount++, this.render(), "function" == typeof this.options.onUpdate && this.options.onUpdate.call(this.$element, this.value), this.loopCount >= this.loops && (clearInterval(this.interval), this.value = this.options.to, "function" == typeof this.options.onComplete && this.options.onComplete.call(this.$element, this.value)) }, e.prototype.render = function () { var t = this.options.formatter.call(this.$element, this.value, this.options); this.$element.text(t) }, e.prototype.restart = function () { this.stop(), this.init(), this.start() }, e.prototype.start = function () { this.stop(), this.render(), this.interval = setInterval(this.update.bind(this), this.options.refreshInterval) }, e.prototype.stop = function () { this.interval && clearInterval(this.interval) }, e.prototype.toggle = function () { this.interval ? this.stop() : this.start() }, t.fn.countTo = function (i) { return this.each(function () { var s = t(this), n = s.data("countTo"), a = !n || "object" == typeof i, r = "object" == typeof i ? i : {}, o = "string" == typeof i ? i : "start"; a && (n && n.stop(), s.data("countTo", n = new e(this, r))), n[o].call(n) }) } }(jQuery), function (t) { function i(t) { this.init(t) } i.prototype = { value: 0, size: 100, startAngle: -Math.PI, thickness: "auto", fill: { gradient: ["#3aeabb", "#fdd250"] }, emptyFill: "rgba(0, 0, 0, .1)", animation: { duration: 1200, easing: "circleProgressEasing" }, animationStartValue: 0, reverse: !1, lineCap: "butt", constructor: i, el: null, canvas: null, ctx: null, radius: 0, arcFill: null, lastFrameValue: 0, init: function (i) { t.extend(this, i), this.radius = this.size / 2, this.initWidget(), this.initFill(), this.draw() }, initWidget: function () { var i = this.canvas = this.canvas || t("<canvas>").prependTo(this.el)[0]; i.width = this.size, i.height = this.size, this.ctx = i.getContext("2d") }, initFill: function () { function i() { var i = t("<canvas>")[0]; i.width = o.size, i.height = o.size, i.getContext("2d").drawImage(r, 0, 0, c, c), o.arcFill = o.ctx.createPattern(i, "no-repeat"), o.drawFrame(o.lastFrameValue) } var e, s, n, a, r, o = this, l = this.fill, h = this.ctx, c = this.size; if (!l) throw Error("The fill is not specified!"); if (l.color && (this.arcFill = l.color), l.gradient) if (e = l.gradient, 1 == e.length) this.arcFill = e[0]; else if (e.length > 1) { var d = l.gradientAngle || 0, u = l.gradientDirection || [c / 2 * (1 - Math.cos(d)), c / 2 * (1 + Math.sin(d)), c / 2 * (1 + Math.cos(d)), c / 2 * (1 - Math.sin(d))], f = h.createLinearGradient.apply(h, u); for (s = 0; s < e.length; s++) n = e[s], a = s / (e.length - 1), t.isArray(n) && (a = n[1], n = n[0]), f.addColorStop(a, n); this.arcFill = f } l.image && (l.image instanceof Image ? r = l.image : (r = new Image, r.src = l.image), r.complete ? i() : r.onload = i) }, draw: function () { this.animation ? this.drawAnimated(this.value) : this.drawFrame(this.value) }, drawFrame: function (t) { this.lastFrameValue = t, this.ctx.clearRect(0, 0, this.size, this.size), this.drawEmptyArc(t), this.drawArc(t) }, drawArc: function (t) { var i = this.ctx, e = this.radius, s = this.getThickness(), n = this.startAngle; i.save(), i.beginPath(), this.reverse ? i.arc(e, e, e - s / 2, n - 2 * Math.PI * t, n) : i.arc(e, e, e - s / 2, n, n + 2 * Math.PI * t), i.lineWidth = s, i.lineCap = this.lineCap, i.strokeStyle = this.arcFill, i.stroke(), i.restore() }, drawEmptyArc: function (t) { var i = this.ctx, e = this.radius, s = this.getThickness(), n = this.startAngle; 1 > t && (i.save(), i.beginPath(), 0 >= t ? i.arc(e, e, e - s / 2, 0, 2 * Math.PI) : this.reverse ? i.arc(e, e, e - s / 2, n, n - 2 * Math.PI * t) : i.arc(e, e, e - s / 2, n + 2 * Math.PI * t, n), i.lineWidth = s, i.strokeStyle = this.emptyFill, i.stroke(), i.restore()) }, drawAnimated: function (i) { var e = this, s = this.el, n = t(this.canvas); n.stop(!0, !1), s.trigger("circle-animation-start"), n.css({ animationProgress: 0 }).animate({ animationProgress: 1 }, t.extend({}, this.animation, { step: function (t) { var n = e.animationStartValue * (1 - t) + i * t; e.drawFrame(n), s.trigger("circle-animation-progress", [t, n]) } })).promise().always(function () { s.trigger("circle-animation-end") }) }, getThickness: function () { return t.isNumeric(this.thickness) ? this.thickness : this.size / 14 }, getValue: function () { return this.value }, setValue: function (t) { this.animation && (this.animationStartValue = this.lastFrameValue), this.value = t, this.draw() } }, t.circleProgress = { defaults: i.prototype }, t.easing.circleProgressEasing = function (t, i, e, s, n) { return (i /= n / 2) < 1 ? s / 2 * i * i * i + e : s / 2 * ((i -= 2) * i * i + 2) + e }, t.fn.circleProgress = function (e, s) { var n, a = "circle-progress", r = this.data(a); if ("widget" == e) { if (!r) throw Error('Calling "widget" method on not initialized instance is forbidden'); return r.canvas } if ("value" == e) { if (!r) throw Error('Calling "value" method on not initialized instance is forbidden'); return "undefined" == typeof s ? r.getValue() : (n = arguments[1], this.each(function () { t(this).data(a).setValue(n) })) } return this.each(function () { var s, n = t(this), r = n.data(a), o = t.isPlainObject(e) ? e : {}; r ? r.init(o) : (s = t.extend({}, n.data()), "string" == typeof s.fill && (s.fill = JSON.parse(s.fill)), "string" == typeof s.animation && (s.animation = JSON.parse(s.animation)), o = t.extend(s, o), o.el = n, r = new i(o), n.data(a, r)) }) } }(jQuery), function (t) { t.fn.downCount = function (i, e) { function s() { var t = new Date(o.date), i = a(), s = t - i; if (0 > s) return clearInterval(r), void (e && "function" == typeof e && e()); var l = 1e3, h = 60 * l, c = 60 * h, d = 24 * c, u = Math.floor(s / d), f = Math.floor(s % d / c), p = Math.floor(s % c / h), g = Math.floor(s % h / l); u = String(u).length >= 2 ? u : "0" + u, f = String(f).length >= 2 ? f : "0" + f, p = String(p).length >= 2 ? p : "0" + p, g = String(g).length >= 2 ? g : "0" + g; var m = 1 === u ? "day" : "days", v = 1 === f ? "hour" : "hours", y = 1 === p ? "minute" : "minutes", w = 1 === g ? "second" : "seconds"; n.find(".days").text(u), n.find(".hours").text(f), n.find(".minutes").text(p), n.find(".seconds").text(g), n.find(".days_ref").text(m), n.find(".hours_ref").text(v), n.find(".minutes_ref").text(y), n.find(".seconds_ref").text(w) } var n, a, r, o = t.extend({ date: null, offset: null }, i); o.date || t.error("Date is not defined."), Date.parse(o.date) || t.error("Incorrect date format, it should look like this, 12/24/2012 12:00:00."), n = this, a = function () { var t = new Date, i = t.getTime() + 6e4 * t.getTimezoneOffset(); return new Date(i + 36e5 * o.offset) }, r = setInterval(s, 1e3) } }(jQuery), function (t) { t(document).ready(function () { var i = t("[data-time].countdown"); t(i).each(function (i) { t(this).downCount({ date: t(this).attr("data-time"), offset: t(this).attr("data-utc-offset") }) }), t(window).scroll(function () { i = t(".counter"), t(i).each(function () { if (isScrollView(this)) { var i = t(this).attr("data-trigger"); (isEmpty(i) || "scroll" == i) && (t(this).countTo({ formatter: function (t, i) { return t.toFixed(i.decimals).replace(/\B(?=(?:\d{3})+(?!\d))/g, ".") } }), t(this).attr("data-trigger", "null")) } }), i = t("[data-progress].progress-bar"), t(i).each(function () { if (isScrollView(this)) { var i = t(this).attr("data-trigger"); (isEmpty(i) || "scroll" == i) && (t(this).css("width", 0), t(this).css("width", t(this).attr("data-progress") + "%"), t(this).attr("data-trigger", "null")) } }), i = t("[data-progress].progress-circle"), t(i).each(function () { if (isScrollView(this)) { var i = t(this).attr("data-trigger"); (isEmpty(i) || "scroll" == i) && (t(this).progressCircle(), t(this).attr("data-trigger", "null")) } }) }) }), t.fn.progressCircle = function () { var i, e = t(this).attr("data-options"), s = t(this).attr("data-size"), n = t(this).attr("data-color"), a = t(this).attr("data-unit"), r = t(this).attr("data-thickness"), r = t(this).attr("data-thickness"); isEmpty(n) && (n = "#565656"), isEmpty(r) && (r = 2), (isEmpty(s) || "auto" == s) && (s = t(this).outerWidth()), null == a && (a = "%"); var o = { value: parseInt(t(this).attr("data-progress"), 10) / 100, size: s, fill: { gradient: [n, n] }, thickness: r, startAngle: -Math.PI / 2 }; isEmpty(e) || (i = e.split(","), o = getOptionsString(e, o)), t(this).circleProgress(o); var l = t(this).find(".inner-circle .counter-circle"); l && (t(this).find(".inner-circle").css("display", "table"), t(this).on("circle-animation-progress", function (i, e, s) { t(l).html(parseInt(100 * s.toFixed(2), 10) + " " + a) })) } }(jQuery);


