<?php

namespace App\Repositories\Vendor;

use DB;

class EloquentVendor implements VendorRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all vendors
        * @description  : Used for getting all vendors data 
        * @param        : Request data  
        * @return       : return all vendors data
    */
    public function getAll()
    {
        return DB::table('m40_vendor')->paginate(500);
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting vendor 
        * @param        : Request data  
        * @return       : return with inserting vendor
    */
    public function create(array $attributes)
    {
        return DB::table('m40_vendor')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating vendor 
        * @param        : Request data  
        * @return       : return with updating vendor
    */
    public function update($id, array $attributes)
    {
        return DB::table('m40_vendor')->where('m40_vendor_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting vendor 
        * @param        : Request data  
        * @return       : return with deleting vendor
    */
    public function delete($id)
    {
        return DB::table('m40_vendor')->where('m40_vendor_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single vendor data 
        * @param        : Request data  
        * @return       : return with single vendor
    */
    public function getById($id)
    {   
        return DB::table('m40_vendor')->where('m40_vendor_id', $id)->get();
    }

    /**
        * Method name   : Active
        * @description  : Used for updating vendor status
        * @param        : Request data with vendor id
        * @return       : return with updated vendor status
    */
    public function active($id)
    {
        return DB::update('UPDATE m40_vendor SET m40_vendor_status = case m40_vendor_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m40_vendor_id = "'.$id.'"');
    }

}




