<?php

namespace App\Repositories\Topup;

use DB;

class EloquentTopup implements TopupRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
			* Method name	: Call Topup
			* @description 	: Used for topup
			* @param		: request data 
			* @return		: response with topup
		*/
    public function callTopup(array $attributes)
    {
        return DB::select('CALL topup(:proc,
				  	:txt_userid,
				  	:dd_package,
				  	:dd_user_forwallet,
				  	:dd_wallet,
				  	@status_code,
				  	@status_msg)',$attributes);
    }

    /**
			* Method name	: Call Topup Report
			* @description 	: Used for topup report
			* @param		: request data 
			* @return		: response with topup report
		*/
    public function callTopupReport(array $attributes)
    {
        return DB::select('CALL topup_report(				
					:proc,
					:userid,
					:fromdate,
					:todate,
					:noofrecords,
					:topstatus,
					:descrip,
					@msg
					)',$attributes);
    }

    /**
			* Method name	: Call ReTopup
			* @description 	: Used for retopup
			* @param		: request data 
			* @return		: response with retopup
		*/
    public function callRetopup(array $attributes)
    {
        return DB::select('CALL retopup(				
					:proc,
				  	:txt_userid,
				  	:dd_package,
				  	:dd_user_forwallet,
				  	:dd_wallet,
				  	@status_code,
				  	@status_msg)',$attributes);
    }
}




