<?php

namespace App\Repositories\Ticket;

use DB;

class EloquentTicket implements TicketRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get All
        * @description  : Used for getting all tickets
        * @param        : Request data  
        * @return       : return with all tickets
    */
    public function getAll()
    {
        return DB::select("SELECT * FROM `ticket`");
    }

    /**
        * Method name   : Create
        * @description  : Used for creating ticket
        * @param        : Request data  
        * @return       : return with created ticket
    */
    public function create(array $attributes)
    {
        return DB::table('m46_ticket')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating ticket
        * @param        : Request data  
        * @return       : return with updated ticket
    */
    public function update($id, array $attributes)
    {
        return DB::table('m46_ticket')->where('m46_ticket_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting ticket
        * @param        : Request data  
        * @return       : return with deleted ticket
    */
    public function delete($id)
    {
        return DB::table('m46_ticket')->where('m46_ticket_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting ticket by asssigned to id
        * @param        : Request data  
        * @return       : return with ticket
    */
    public function getById($id)
    {   
        return DB::select("SELECT * FROM `ticket` WHERE TICKET_ID = ".$id."");
    }



    /**
        * Method name   : Get By ASSIGNED TO  Active
        * @description  : Used for getting ticket by asssigned to id
        * @param        : Request data  
        * @return       : return with ticket
    */
    public function getByAssTo($id)
    {   
        return DB::select("SELECT * FROM `ticket` WHERE EMP_ID = ".$id." AND STATUS = 'Active' ");
    }



    /**
        * Method name   : Get By ASSIGNED TO
        * @description  : Used for getting ticket by asssigned to id
        * @param        : Request data  
        * @return       : return with ticket
    */
    public function getByAssToClose($id)
    {   
        return DB::select("SELECT * FROM `ticket` WHERE EMP_ID = ".$id." AND STATUS = 'InActive' ");
    }



    /**
        * Method name   : Get By User Id aCTIVE 
        * @description  : Used for getting ticket by user id
        * @param        : Request data  
        * @return       : return with ticket
    */
    public function getByUserId($id)
    {   
        return DB::select("SELECT * FROM `ticket` WHERE USER_ID = ".$id." AND STATUS = 1");
    }


    /**
        * Method name   : Get By User Id Inactive
        * @description  : Used for getting ticket by user id
        * @param        : Request data  
        * @return       : return with ticket
    */
    public function getByUserIdIn($id)
    {   
        return DB::select("SELECT * FROM `ticket` WHERE USER_ID = ".$id." AND STATUS = 2");
    }

     /**
        * Method name   : Active
        * @description  : Used for active or inactive ticket
        * @param        : Request data  
        * @return       : return with ticket
    */
    public function active($id)
    {
        return DB::update('UPDATE m46_ticket SET m46_status = case m46_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m46_ticket_id = "'.$id.'"');
    }

     /**
        * Method name   : Create reply
        * @description  : Used for creating reply by user or employee
        * @param        : Request data  
        * @return       : return with reply on ticket
    */
    public function create_reply(array $attributes)
    {
        return DB::table('tr34_ticket_reply')->insert($attributes);
    }


     /**
        * Method name   : get by Ticket ID reply
        * @description  : Used for creating reply by user or employee
        * @param        : Request data  
        * @return       : return with reply on ticket
    */
    public function GetByTicketId($id)
    {
        return DB::table('ticket_reply')->where('TKT_ID', $id)->get();
    }

}

