<?php

namespace App\Repositories\Team;

use DB;

class EloquentTeam implements TeamRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get By User Id
        * @description  : Used for getting user tree by id
        * @param        : Request data  
        * @return       : return with user tree
    */
    public function getByUserId()
    {
        return DB::select("SELECT * FROM `tree` WHERE `USER_ID` IN (SELECT * FROM total_user)");
    }

    /**
        * Method name   : Get User At Level
        * @description  : Used for get user at level
        * @param        : Request data  
        * @return       : return with user level
    */
    public function getUserAtLevel($id)
    {
        return DB::select(" CALL user_at_level($id,3) ");
    }

    /**
        * Method name   : Get Intro Downline Zero
        * @description  : Used for get downline zero
        * @param        : Request data  
        * @return       : return with downline
    */
    public function getIntroDownlineZero()
    {
        return DB::select("CALL get_intro_downline(0)");
    }

    /**
        * Method name   : Get Tmp Downline
        * @description  : Used for get tmp downline
        * @param        : Request data  
        * @return       : return with tmp downline
    */
    public function getTmpDownline()
    {
        return DB::select("SELECT member_id,level_id FROM tmp_downline");
    }

     /**
        * Method name   : Get Tmp Downline
        * @description  : Used for get tmp downline
        * @param        : Request data  
        * @return       : return with tmp downline
    */
    public function getTmpDownline1()
    {
        return DB::select("SELECT member_id FROM tmp_downline");
    }

    /**
        * Method name   : Get Intro Downline
        * @description  : Used for get intro downline
        * @param        : Request data  
        * @return       : return with intro downline
    */
    public function getIntroDownline($userid)
    {
        return DB::select("CALL get_intro_downline(".$userid.")");
    }

      /**
        * Method name   : Get Downline
        * @description  : Used for get downline
        * @param        : Request data  
        * @return       : return with  downline
    */
    public function getDownline($userid,$position)
    {
        return DB::select("CALL get_downline(".$userid.",'".$position."')");
    }
}




