<?php

namespace App\Repositories\Store;

use DB;

class EloquentStore implements StoreRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all stores
        * @description  : Used for getting all stores data 
        * @param        : Request data  
        * @return       : return all stores data
    */
    public function getAll()
    {
        return DB::table('m44_store')->paginate(500);
    }


    /**
        * Method name   : Create
        * @description  : Used for inserting store 
        * @param        : Request data  
        * @return       : return with inserting store
    */
    public function create(array $attributes)
    {
        return DB::table('m44_store')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating store 
        * @param        : Request data  
        * @return       : return with updating store
    */
    public function update($id, array $attributes)
    {
        return DB::table('m44_store')->where('m44_store_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting store 
        * @param        : Request data  
        * @return       : return with deleting store
    */
    public function delete($id)
    {
        return DB::table('m44_store')->where('m44_store_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single store data 
        * @param        : Request data  
        * @return       : return with deleting store
    */
    public function getById($id)
    {   
        return DB::table('m44_store')->where('m44_store_id', $id)->get();
    }

    /**
        * Method name   : Active
        * @description  : Used for updating store status
        * @param        : Request data with store id
        * @return       : return with updated store status
    */
    public function active($id)
    {
        return DB::update('UPDATE m44_store SET m44_store_status = case m44_store_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m44_store_id = "'.$id.'"');
    }

}




