<?php

namespace App\Repositories\Slab;

use DB;

class EloquentSlab implements SlabRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all slab
        * @description  : Used for getting all slab data 
        * @param        : Request data  
        * @return       : return all slab data
    */
    public function getAll()
    {
        $arr = DB::select("SELECT * FROM `group` WHERE 1");
        return $arr;
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting slab 
        * @param        : Request data  
        * @return       : return with inserting slab
    */
    public function create(array $attributes)
    {
        return DB::table('m16_group')->insertGetId($attributes);
    }

    /**
        * Method name   : Create Slab Margin
        * @description  : Used for inserting slab margin 
        * @param        : Request data  
        * @return       : return with inserting slab margin
    */
    public function createSlabMargin(array $attributes)
    {
        $result =  DB::select('CALL slab_margin(
            :proc,
            :userid,
            :telecombrandid,
            :desig,
            :apiid,
            @msg
            )',$attributes);
        return $result;
    }

    /**
        * Method name   : Update
        * @description  : Used for updating slab 
        * @param        : Request data  
        * @return       : return with updating slab
    */
    public function update($id, array $attributes)
    {
        return DB::table('m16_group')->where('m16_gr_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting slab 
        * @param        : Request data  
        * @return       : return with deleting slab
    */
    public function delete($id)
    {
        return DB::table('m16_group')->where('m16_gr_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single slab data 
        * @param        : Request data  
        * @return       : return with single slab
    */
    public function getById($id)
    {   
        return DB::select("SELECT * FROM `group` WHERE GROUP_ID = ".$id."");
    }

    /**
        * Method name   : Active
        * @description  : Used for updating slab status
        * @param        : Request data with slab id
        * @return       : return with updated slab status
    */
    public function active($id)
    {
        return DB::update('UPDATE m16_group SET m16_gr_status = case m16_gr_status when "ACTIVE" then "DEACTIVE"
         when "DEACTIVE" then "ACTIVE" end WHERE m16_gr_id = "'.$id.'"');
    }


    /**
        * Method name   : Update prepaid margin slab wise
        * @description  : Used for updating prepaid margin slab wise
        * @param        : Request data  
        * @return       : return with updating prepaid margin slab wise
    */
    public function updatePrepaidMarginSW($id, array $attributes)
    {
        return DB::table('tr07_group_margin')->where('tr07_grop_mid', $id)->update($attributes);
    }

 
    /**
        * Method name   : Update utility margin slab wise
        * @description  : Used for updating utility margin slab wise
        * @param        : Request data  
        * @return       : return with updating prepaid utility slab wise
    */
    public function updateUtilityMarginSW($id, array $attributes)
    {
        return DB::table('tr24_group_utility')->where('tr24_group_utltyid', $id)->update($attributes);
    }

    /**
        * Method name   : Update dmr surcharge
        * @description  : Used for updating dmr surcharge slab wise
        * @param        : Request data  
        * @return       : return with updating dmr surcharge slab wise
    */
    public function updateDmrSurcharge($id, array $attributes)
    {
        return DB::table('tr17_group_dmr')->where('tr17_group_dmrid', $id)->update($attributes);
    }

    /**
        * Method name   : Update dmr surcharge
        * @description  : Used for updating dmr surcharge slab wise
        * @param        : Request data  
        * @return       : return with updating dmr surcharge slab wise
    */
    public function updatePrepaidApiSequence($id, array $attributes)
    {
        return DB::table('tr06_group_op')->where('tr06_grop_id', $id)->update($attributes);
    }

     /**
        * Method name   : Update utility api sequences
        * @description  : Used for updating utility api sequences
        * @param        : Request data  
        * @return       : return with updating utility api sequences
    */
    public function updateUtilityApiSequence($id, array $attributes)
    {
        return DB::table('tr06_group_op')->where('tr06_grop_id', $id)->update($attributes);
    }


}




