<?php

namespace App\Repositories\Recharge\Rechargereport;
use DB;

class EloquentRechargereport implements RechargereportRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Recharge Report
        * @description  : Used for getting recharge report
        * @param        : Request data  
        * @return       : return with recharge report
    */
    public function rechargeReport(array $attributes)
    {
        return DB::select('CALL recharge_report(
		         :proc,
		         :account,
		         :transid, 
		         :userid,
		         :fromdate,
		         :todate,
		         :noofrecords,
		         :recstatus,
		         :descrip,
		         @msg
		     )',$attributes);
    }  

 /**
        * Method name   : Refund Report
        * @description  : Used for getting recharge report
        * @param        : Request data  
        * @return       : return with recharge report
    */
    public function refundReport(array $attributes)
    {
        return DB::select('CALL refund(
		         :proc,
		         :recharge_id,
		         :descrip, 
		         :defaultstatus,
				 @msg,
		         @msg1
		     )',$attributes);
    }  

	 /**
        * Method name   : Daily Operator Sales
        * @description  : Used for daily operator sales
        * @param        : Request data  
        * @return       : return with daily operator sales
    */
    public function dailyOperatorSales(array $attributes)
    {
        return DB::select('CALL daily_operator_sales(
                :proc,
                :userid,
                :fromdate,
                :todate,
                :descrip,
                @msg
               )',$attributes);
    }


    /**
        * Method name   : Today Hit Status
        * @description  : Used for today hit status
        * @param        : Request data  
        * @return       : return with today hit status
    */
    public function todayHitStatus(array $attributes)
    {
        return DB::select('CALL today_hitstatus(                
                :proc,
                :user_id,
                :rec_fromdate,
                :rec_todate
                )',$attributes);
    }


     /**
        * Method name   : Today Hit Status
        * @description  : Used for today hit status
        * @param        : Request data  
        * @return       : return with today hit status
    */
    public function dateWiseSales(array $attributes)
    {
        return DB::select('CALL today_hitstatus(                
                :proc,
                :user_id,
                :rec_fromdate,
                :rec_todate
                )',$attributes);
    }

    /**
        * Method name   : Today Hit Status
        * @description  : Used for today hit status
        * @param        : Request data  
        * @return       : return with today hit status
    */
    public function apiWiseSales(array $attributes)
    {
        return DB::select('CALL today_hitstatus(                
                :proc,
                :user_id,
                :rec_fromdate,
                :rec_todate
                )',$attributes);
    }
    
        /**
        * Method name   : Today Hit Status
        * @description  : Used for today hit status
        * @param        : Request data  
        * @return       : return with today hit status
    */
    public function userWiseSales(array $attributes)
    {
        return DB::select('CALL today_hitstatus(                
                :proc,
                :user_id,
                :rec_fromdate,
                :rec_todate
                )',$attributes);
    }

    /**
        * Method name   : Day Book
        * @description  : Used for today hit status
        * @param        : Request data  
        * @return       : return with today hit status
    */
    public function userDayBook(array $attributes)
    {
        return DB::select('CALL day_book(                
                :proc,
                :user_id,
                :fromdate,
                :todate,
				 @msg
                )',$attributes);
    }

/**
        * Method name   : BillPay Report
        * @description  : Used for getting Billpay report
        * @param        : Request data  
        * @return       : return with recharge report
    */
    public function billpayReport(array $attributes)
    {
        return DB::select('CALL billpay_report(
		         :proc,
				 :mobile,
		         :account,
		         :transid, 
		         :userid,
		         :fromdate,
		         :todate,
		         :noofrecords,
		         :recstatus,
		         :descrip,
		         @msg
		     )',$attributes);
    }  

}