<?php

namespace App\Repositories\Recharge\Rechargeprocess;
use DB;

class EloquentRechargeprocess implements RechargeprocessRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeStatusUpdate(array $attributes)
    {
        return DB::select('CALL recharge_statusupdate(
		         :proc,
		         :userid,
		         :account, 
		         :transid,
		         :liveid,
		         :amt,
		         :recstatus,
		         :descrip,
		         @msg
		       )',$attributes);
    }

    /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function doRecharge(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }



	 /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeTIdUpdate(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }

	 /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeComplaint(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }

	 /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeHitCallback(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }
 /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeResend(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }
 /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeAutoResend(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }


/**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function rechargeCallBack(array $attributes)
    {

        return DB::select('CALL dorecharge(                
                    :proc,
                    :user_id,
                    :mobile,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }

 /**
        * Method name   : Recharge Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function doBillpay(array $attributes)
    {

        return DB::select('CALL pay_bill(                
                    :proc,
                    :user_id,
                    :mobile,
					:account,
                    :operator,
                    :amount,
                    :requesttype,
                    :servicetype,
                    :agentid,
                    :format,
                    :timelimit,
                    :defaultstatus,
                    @msg,
                    @msg2
                    )',$attributes);
    }


 /**
        * Method name   : Bill pay Status Update
        * @description  : Used for updating recharge status
        * @param        : Request data  
        * @return       : return with updated recharge status
    */
    public function billpayStatusUpdate(array $attributes)
    {
        return DB::select('CALL billpay_statusupdate(
		         :proc,
		         :userid,
		         :account, 
		         :transid,
		         :liveid,
		         :amt,
		         :recstatus,
		         :descrip,
		         @msg
		       )',$attributes);
    }


}