<?php

namespace App\Repositories\Profile;

use DB;

class EloquentProfile implements ProfileRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all banks
        * @param        : Request data
        * @return       : return all banks
    */
    public function updateBankByUserId($userid, array $attributes)
    {
        return DB::table('m23_user_bankdetails')->where('m11_user_id', $userid)->update($attributes);
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all banks
        * @param        : Request data
        * @return       : return all banks
    */
    public function updateKycByUserId($userid, array $attributes)
    {
        return DB::table('m19_user_kyc')->where('m11_user_id', $userid)->update($attributes);
    }

    /**
        * Method name   : Update bank by emp id
        * @description  : Used for updating employee bank details
        * @param        : Request data
        * @return       : return updated employee bank details
    */
    public function updateBankByEmpId($userid, array $attributes)
    {
        return DB::table('m32_employee_bankdetails')->where('m30_employee_id', $userid)->update($attributes);
    }

    /**
        * Method name   : Update kyc by emp id
        * @description  : Used for updating employee kyc details
        * @param        : Request data
        * @return       : return updated employee kyc details
    */
    public function updateKycByEmpId($userid, array $attributes)
    {
        return DB::table('m31_employee_kyc')->where('m30_employee_id', $userid)->update($attributes);
    }  


    /**
        * Method name   : add beneficiary
        * @description  : Used for add beneficiary
        * @param        : Request data
        * @return       : return updated beneficiary info
    */
    public function Insertbeneficiary(array $attributes)
    {
        return DB::table('m79_user_beneficiary')->insert($attributes);
    }

    /**
        * Method name   : add beneficiary
        * @description  : Used for add beneficiary
        * @param        : Request data
        * @return       : return updated beneficiary info
    */
    public function Updatebeneficiary($userid, array $attributes)
    {
        return DB::table('m79_user_beneficiary')->where('m28_bene_beneficiary_id', $userid)->update($attributes);
    }

    /**
        * Method name   : add beneficiary
        * @description  : Used for add beneficiary
        * @param        : Request data
        * @return       : return updated beneficiary info
    */
    public function Getbeneficiary($userid)
    {
        return DB::table('beneficiary')->where('BENEFICIARY_ID', $userid)->first();
    }    

    /**
        * Method name   : add beneficiary
        * @description  : Used for add beneficiary
        * @param        : Request data
        * @return       : return updated beneficiary info
    */
    public function GetAllbeneficiary()
    {
        return DB::table('beneficiary')->get();
    }

    

}




