<?php

namespace App\Repositories\ProductModule\Wishlist;

use DB;

class EloquentWishlist implements WishlistRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all users favorite product data 
        * @param        : Request data  
        * @return       : return all users order
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `user_wishlist`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating user favorites 
        * @param        : Request data  
        * @return       : return with creating user favorites
    */
    public function create(array $attributes)
    {
        return DB::table('tr39_user_wishlist')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating user favorites 
        * @param        : Request data  
        * @return       : return with updating user favorites
    */
    public function update($id, array $attributes)
    {
        return DB::table('tr39_user_wishlist')->where('tr39_user_wishlist_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting user favorites  
        * @param        : Request data  
        * @return       : return with deleting user favorites 
    */
    public function delete($id)
    {
        return DB::table('tr39_user_wishlist')->where('tr39_user_wishlist_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user favorites 
        * @param        : Request data  
        * @return       : return with single user favorites
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `user_wishlist` WHERE WISH_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user favorites 
        * @param        : Request data  
        * @return       : return with single user favorites 
    */
    public function getByUserId($id)
    {   
        return DB::select('SELECT * FROM `user_wishlist` WHERE USER_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by prod id
        * @description  : Used for getting single user favorites by prod id
        * @param        : Request data  
        * @return       : return with getting single user favorites by prod id
    */
    public function getByProdId($id)
    {   
        return DB::select('SELECT COUNT(*) AS CON FROM `user_wishlist` WHERE PROD_ID = "'.$id.'"');
    }

}




