<?php

namespace App\Repositories\ProductModule\UserOrders;

use DB;

class EloquentUserOrders implements UserOrdersRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all users order data 
        * @param        : Request data  
        * @return       : return all users order
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `user_orders`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating user order 
        * @param        : Request data  
        * @return       : return with creating user order
    */
    public function create(array $attributes)
    {
        return DB::table('tr36_user_order')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating user order 
        * @param        : Request data  
        * @return       : return with updating user order
    */
    public function update($id, array $attributes)
    {
        return DB::table('tr36_user_order')->where('tr36_user_order_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting user order  
        * @param        : Request data  
        * @return       : return with deleting user order 
    */
    public function delete($id)
    {
        return DB::table('tr36_user_order')->where('tr36_user_order_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user order 
        * @param        : Request data  
        * @return       : return with single user order
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `user_orders` WHERE ORDER_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by order code
        * @description  : Used for getting single user order 
        * @param        : Request data  
        * @return       : return with single user order
    */
    public function getByOrderCode($id)
    {   
        return DB::select('SELECT * FROM `user_orders` WHERE ORDER_CODE = "'.$id.'"');
    }

    public function getByOrderCodeAndUserId($id, $user_id)
    {   
        return DB::select('SELECT * FROM `user_orders` WHERE ORDER_CODE = "'.$id.'" AND USER_ID = '.$user_id);
    }


    public function getByOrderCodeWish($user_id, $cart_type)
    {   
        return DB::select('SELECT * FROM `user_orders` WHERE USER_ID = "'.$user_id.'" AND CART_TYPE = "'.$cart_type.'" ORDER BY ORDER_ID DESC LIMIT 1');
    }


    /**
        * Method name   : Get by id
        * @description  : Used for getting single user order 
        * @param        : Request data  
        * @return       : return with single user order 
    */
    public function getByUserId($id)
    {   
        return DB::select('SELECT * FROM `user_orders` WHERE USER_ID = "'.$id.'" ORDER BY ORDER_ID DESC');
    }

    public function getByUserIdFinal($id)
    {   
        return DB::select('SELECT * FROM `user_orders` WHERE USER_ID = "'.$id.'" AND CART_TYPE != "WISHLIST" ORDER BY ORDER_ID DESC');
    }

}



