<?php

namespace App\Repositories\ProductModule\UserAddress;

use DB;

class EloquentUserAddress implements UserAddressRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all users addresses data 
        * @param        : Request data  
        * @return       : return all users order
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `user_addresses`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating user addresses 
        * @param        : Request data  
        * @return       : return with creating user addresses
    */
    public function create(array $attributes)
    {
        return DB::table('m73_user_address')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating user addresses 
        * @param        : Request data  
        * @return       : return with updating user addresses
    */
    public function update($id, array $attributes)
    {
        return DB::table('m73_user_address')->where('m73_user_address_id', $id)->update($attributes);
    }

	/**
        * Method name   : Update
        * @description  : Used for updating user addresses 
        * @param        : Request data  
        * @return       : return with updating user addresses
    */
    public function updateByUserId($id, array $attributes)
    {
        return DB::table('m73_user_address')->where('m11_user_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting user addresses  
        * @param        : Request data  
        * @return       : return with deleting user addresses 
    */
    public function delete($id)
    {
        return DB::table('m73_user_address')->where('m73_user_address_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user addresses 
        * @param        : Request data  
        * @return       : return with single user addresses
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `user_addresses` WHERE ADD_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user addresses 
        * @param        : Request data  
        * @return       : return with single user addresses 
    */
    public function getByUserId($id)
    {   
        return DB::select('SELECT * FROM `user_addresses` WHERE USER_ID = "'.$id.'"');
    }
	
	/**
        * Method name   : Get user default
        * @description  : Used for getting user default addresses 
        * @param        : Request data  
        * @return       : return with single user default addresses 
    */
    public function getUserDefault($id)
    {   
        return DB::select('SELECT * FROM `user_addresses` WHERE USER_ID = "'.$id.'" AND IS_DEFAULT="YES"');
    }

}


