<?php

namespace App\Repositories\ProductModule\Unit;

use DB;

class EloquentUnit implements UnitRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all units data 
        * @param        : Request data  
        * @return       : return all units data
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `unit`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting unit 
        * @param        : Request data  
        * @return       : return with inserting unit
    */
    public function create(array $attributes)
    {
        return DB::table('m37_unit')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating unit 
        * @param        : Request data  
        * @return       : return with updating unit
    */
    public function update($id, array $attributes)
    {
        return DB::table('m37_unit')->where('m37_unit_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting unit 
        * @param        : Request data  
        * @return       : return with deleting unit
    */
    public function delete($id)
    {
        return DB::table('m37_unit')->where('m37_unit_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single unit data 
        * @param        : Request data  
        * @return       : return with single unit data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `unit` WHERE UNIT_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating unit status
        * @param        : Request data with unit id
        * @return       : return with updated unit status
    */
    public function active($id)
    {
        return DB::update('UPDATE m37_unit SET m37_status = case m37_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m37_unit_id = "'.$id.'"');
    }
}




