<?php

namespace App\Repositories\ProductModule\Products;

use DB;

class EloquentProducts implements ProductsRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all products data 
        * @param        : Request data  
        * @return       : return all products data
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `products_listing` ORDER BY PROD_ID DESC');
    }

    public function getAllActive()
    {
        return DB::select('SELECT * FROM `products_listing` WHERE STATUS = "ACTIVE"  ORDER BY PROD_ID DESC');
    }

	public function getEightActive()
    {
        return DB::select('SELECT * FROM `front_product_listing` WHERE STATUS = "ACTIVE" ORDER BY PROD_ID DESC ');
    }
    /**
        * Method name   : Create
        * @description  : Used for inserting product 
        * @param        : Request data  
        * @return       : return with inserting product
    */
    public function create(array $attributes)
    {
        return DB::table('m33_products')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating product 
        * @param        : Request data  
        * @return       : return with updating product
    */
    public function update($id, array $attributes)
    {
        return DB::table('m33_products')->where('m33_product_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting product 
        * @param        : Request data  
        * @return       : return with deleting product
    */
    public function delete($id)
    {
        return DB::table('m33_products')->where('m33_product_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single product data 
        * @param        : Request data  
        * @return       : return with single product data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `products_listing` WHERE PROD_ID = "'.$id.'"');
    }


    public function getByName($id)
    {   
        return DB::select('SELECT * FROM `products_listing` WHERE PROD_NAME = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating product status
        * @param        : Request data with product id
        * @return       : return with updated product status
    */
    public function active($id)
    {
        return DB::update('UPDATE m33_products SET m33_status = case m33_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m33_product_id = "'.$id.'"');
    }

	/**
        * Method name   : Get by cat id
        * @description  : Used for get by cat id
        * @param        : Request data  
        * @return       : return with get by cat id
    */
    public function getByCatId($id)
    {   
        return DB::select('SELECT * FROM `products_listing` WHERE PROD_CATID = "'.$id.'"');
    }

    
    public function getByCatParentId($id)
    {   
        return DB::select('SELECT * FROM `products_listing` WHERE CAT_PARENT_ID = "'.$id.'"');
    }


    public function getByCatIdPage($id, $sort, $noofrecords)
    {   
        if($sort == 'atoz')
        {
            return DB::table('products_listing')->where('PROD_CATID', $id)->orderBy('PROD_NAME', 'ASC')->paginate($noofrecords);
        }
        elseif($sort == 'ztoa')
        {
            return DB::table('products_listing')->where('PROD_CATID', $id)->orderBy('PROD_NAME', 'DESC')->paginate($noofrecords);
        }
        elseif($sort == 'lowtohigh')
        {
            return DB::table('products_listing')->where('PROD_CATID', $id)->orderBy('PROD_PRICE', 'ASC')->paginate($noofrecords);
        }
        elseif($sort == 'hightolow')
        {
            return DB::table('products_listing')->where('PROD_CATID', $id)->orderBy('PROD_PRICE', 'DESC')->paginate($noofrecords);
        }
        else
        {
           return DB::table('products_listing')->where('PROD_CATID', $id)->orderBy('PROD_ID', 'DESC')->paginate($noofrecords); 
        }
    }


    public function getByCatParentIdPage($id, $sort, $noofrecords)
    {   
        if($sort == 'atoz')
        {
            return DB::table('products_listing')->where('CAT_PARENT_ID', $id)->orderBy('PROD_NAME', 'ASC')->paginate($noofrecords);
        }
        elseif($sort == 'ztoa')
        {
            return DB::table('products_listing')->where('CAT_PARENT_ID', $id)->orderBy('PROD_NAME', 'DESC')->paginate($noofrecords);
        }
        elseif($sort == 'lowtohigh')
        {
            return DB::table('products_listing')->where('CAT_PARENT_ID', $id)->orderBy('PROD_PRICE', 'ASC')->paginate($noofrecords);
        }
        elseif($sort == 'hightolow')
        {
            return DB::table('products_listing')->where('CAT_PARENT_ID', $id)->orderBy('PROD_PRICE', 'DESC')->paginate($noofrecords);
        }
        else
        {
           return DB::table('products_listing')->where('CAT_PARENT_ID', $id)->orderBy('PROD_ID', 'DESC')->paginate($noofrecords); 
        }
        
    }

}



