<?php

namespace App\Repositories\ProductModule\ProductVariant;

use DB;

class EloquentProductVariant implements ProductVariantRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all products data 
        * @param        : Request data  
        * @return       : return all products data
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `product_variants`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting product 
        * @param        : Request data  
        * @return       : return with inserting product
    */
    public function create(array $attributes)
    {
        return DB::table('m74_product_variant')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating product 
        * @param        : Request data  
        * @return       : return with updating product
    */
    public function update($id, array $attributes)
    {
        return DB::table('m74_product_variant')->where('m74_product_variant_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting product 
        * @param        : Request data  
        * @return       : return with deleting product
    */
    public function delete($id)
    {
        return DB::table('m74_product_variant')->where('m74_product_variant_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single product data 
        * @param        : Request data  
        * @return       : return with single product data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `product_variants` WHERE VARNT_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating product status
        * @param        : Request data with product id
        * @return       : return with updated product status
    */
    public function active($id)
    {
        return DB::update('UPDATE m74_product_variant SET m74_status = case m74_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m74_product_variant_id = "'.$id.'"');
    }

	/**
        * Method name   : Get by product id
        * @description  : Used for get by product id
        * @param        : Request data  
        * @return       : return with get by product id
    */
    public function getByProductId($id)
    {   
        return DB::select('SELECT * FROM `product_variants` WHERE PROD_ID = "'.$id.'"');
    }

}


