<?php

namespace App\Repositories\ProductModule\ParentCategories;

use DB;

class EloquentParentCategories implements ParentCategoriesRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all category data 
        * @param        : Request data  
        * @return       : return all category data
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `shopping_for`');
    }

    public function getAllActive()
    {
        return DB::select('SELECT * FROM `shopping_for` WHERE CAT_STATUS = "ACTIVE"');
    }


    /**
        * Method name   : Get by id
        * @description  : Used for getting parent cat by id
        * @param        : Request data  
        * @return       : return all getting parent cat by id
    */
    public function getById($id)
    {
        return DB::select('SELECT * FROM `shopping_for` WHERE CAT_ID ='.$id);
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting category 
        * @param        : Request data  
        * @return       : return with inserting category
    */
    public function create(array $attributes)
    {
        return DB::table('m39_shopping_for')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating category 
        * @param        : Request data  
        * @return       : return with updating category
    */
    public function update($id, array $attributes)
    {
        return DB::table('m39_shopping_for')->where('m39_shopping_for_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting category 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function delete($id)
    {
        return DB::table('m39_shopping_for')->where('m39_shopping_for_id', $id)->delete();
    }

    
}

