<?php

namespace App\Repositories\ProductModule\OrdersSiping;

use DB;

class EloquentOrdersSiping implements OrdersSipingRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all users order data 
        * @param        : Request data  
        * @return       : return all users order
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `shipment_info`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating user order 
        * @param        : Request data  
        * @return       : return with creating user order
    */
    public function create(array $attributes)
    {
        return DB::table('tr45_shipment_info')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating user order 
        * @param        : Request data  
        * @return       : return with updating user order
    */
    public function update($id, array $attributes)
    {
        return DB::table('tr45_shipment_info')->where('tr45_id', $id)->update($attributes);
    }    


    public function updateByShipment($id, array $attributes)
    {
        return DB::table('tr45_shipment_info')->where('tr45_shipment_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting user order  
        * @param        : Request data  
        * @return       : return with deleting user order 
    */
    public function delete($id)
    {
        return DB::table('tr45_shipment_info')->where('tr45_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user order 
        * @param        : Request data  
        * @return       : return with single user order
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `shipment_info` WHERE ID = "'.$id.'"');
    }


    /**
        * Method name   : Get by id
        * @description  : Used for getting single user order 
        * @param        : Request data  
        * @return       : return with single user order
    */
    public function getByCartId($id)
    {   
        return DB::select('SELECT * FROM `shipment_info` WHERE CART_ID = "'.$id.'"');
    }



    /**
        * Method name   : Get by id
        * @description  : Used for getting single user order 
        * @param        : Request data  
        * @return       : return with single user order
    */
    public function getBySipmentId($id)
    {   
        return DB::select('SELECT * FROM `shipment_info` WHERE SHIPMENT_Id = "'.$id.'"');
    }




}



