<?php

namespace App\Repositories\ProductModule\OptionType;

use DB;

class EloquentOptionType implements OptionTypeRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all option type 
        * @param        : Request data  
        * @return       : return all option type
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `option_type`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting option type  
        * @param        : Request data  
        * @return       : return with inserting option type 
    */
    public function create(array $attributes)
    {
        return DB::table('m75_option_type')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating option type  
        * @param        : Request data  
        * @return       : return with updating option type 
    */
    public function update($id, array $attributes)
    {
        return DB::table('m75_option_type')->where('m75_option_type_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting option type  
        * @param        : Request data  
        * @return       : return with deleting option type 
    */
    public function delete($id)
    {
        return DB::table('m75_option_type')->where('m75_option_type_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single option type data 
        * @param        : Request data  
        * @return       : return with single option type data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `option_type` WHERE OP_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating option type status
        * @param        : Request data with option type id
        * @return       : return with updated option type status
    */
    public function active($id)
    {
        return DB::update('UPDATE m75_option_type SET m75_status = case m75_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m75_option_type_id = "'.$id.'"');
    }

    /**
        * Method name   : Get by option id
        * @description  : Used for getting single option type data 
        * @param        : Request data  
        * @return       : return with single option type data
    */
    public function getByOptionId($id)
    {   
        return DB::select('SELECT * FROM `option_type` WHERE GR_ID = "'.$id.'"');
    }
}




