<?php

namespace App\Repositories\ProductModule\OnlinePayment;

use DB;

class EloquentOnlinePayment implements OnlinePaymentRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all users addresses data 
        * @param        : Request data  
        * @return       : return all users order
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `online_payment`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating user addresses 
        * @param        : Request data  
        * @return       : return with creating user addresses
    */
    public function create(array $attributes)
    {
        return DB::table('tr31_online_payment')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating user addresses 
        * @param        : Request data  
        * @return       : return with updating user addresses
    */
    public function update($id, array $attributes)
    {
        return DB::table('tr31_online_payment')->where('tr31_op_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting user addresses  
        * @param        : Request data  
        * @return       : return with deleting user addresses 
    */
    public function delete($id)
    {
        return DB::table('tr31_online_payment')->where('tr31_op_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user addresses 
        * @param        : Request data  
        * @return       : return with single user addresses
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `online_payment` WHERE OP_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user addresses 
        * @param        : Request data  
        * @return       : return with single user addresses 
    */
    public function getByUserId($id)
    {   
        return DB::select('SELECT * FROM `online_payment` WHERE USER_ID = "'.$id.'"');
    }

}




