<?php

namespace App\Repositories\ProductModule\Market;

use DB;

class EloquentMarket implements MarketRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all market data 
        * @param        : Request data  
        * @return       : return all products data
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `market`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating market 
        * @param        : Request data  
        * @return       : return with creating market
    */
    public function create(array $attributes)
    {
        return DB::table('m38_markets')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating market 
        * @param        : Request data  
        * @return       : return with updating market
    */
    public function update($id, array $attributes)
    {
        return DB::table('m38_markets')->where('m38_markets_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting market 
        * @param        : Request data  
        * @return       : return with deleting market
    */
    public function delete($id)
    {
        return DB::table('m38_markets')->where('m38_markets_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single market data 
        * @param        : Request data  
        * @return       : return with single market data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `market` WHERE MK_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating market status
        * @param        : Request data with market id
        * @return       : return with updated market status
    */
    public function active($id)
    {
        return DB::update('UPDATE m38_markets SET m38_market_status = case m38_market_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m38_markets_id = "'.$id.'"');
    }

}



