<?php

namespace App\Repositories\ProductModule\Favorites;

use DB;

class EloquentFavorites implements FavoritesRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all users favorite product data 
        * @param        : Request data  
        * @return       : return all users order
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `user_favourite`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating user favorites 
        * @param        : Request data  
        * @return       : return with creating user favorites
    */
    public function create(array $attributes)
    {
        return DB::table('tr38_user_favourite')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating user favorites 
        * @param        : Request data  
        * @return       : return with updating user favorites
    */
    public function update($id, array $attributes)
    {
        return DB::table('tr38_user_favourite')->where('tr38_user_favourite_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting user favorites  
        * @param        : Request data  
        * @return       : return with deleting user favorites 
    */
    public function delete($id)
    {
        return DB::table('tr38_user_favourite')->where('tr38_user_favourite_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single user favorites 
        * @param        : Request data  
        * @return       : return with single user favorites
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `user_favourite` WHERE FAV_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by user id
        * @description  : Used for getting single user favorites 
        * @param        : Request data  
        * @return       : return with single user favorites 
    */
    public function getByUserId($id)
    {   
        return DB::select('SELECT * FROM `user_favourite` WHERE USER_ID = "'.$id.'"');
    }

    /**
        * Method name   : Get by prod id
        * @description  : Used for getting single user favorites by prod id
        * @param        : Request data  
        * @return       : return with getting single user favorites by prod id
    */
    public function getByProdId($id)
    {   
        return DB::select('SELECT COUNT(*) AS CON FROM `user_favourite` WHERE PROD_ID = "'.$id.'"');
    }

}




