<?php

namespace App\Repositories\ProductModule\Categories;

use DB;

class EloquentCategories implements CategoriesRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all category data 
        * @param        : Request data  
        * @return       : return all category data
    */
    public function getAllCategory()
    {
        return DB::select('SELECT * FROM `category` WHERE CAT_PARENTID = 0');
    }

    public function getAllCategoryActive()
    {
        return DB::select('SELECT * FROM `category`  WHERE CAT_PARENTID = 0 AND CAT_STATUS = "ACTIVE"');
    }


    public function getAllCategoryActiveRand()
    {
        return DB::table('category')->where('CAT_PARENTID', 0)->where('CAT_STATUS', 'ACTIVE')->inRandomOrder()->limit(3)->get();
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all category data 
        * @param        : Request data  
        * @return       : return all category data
    */
    public function getAllSubCategory()
    {
        return DB::select('SELECT * FROM `category` WHERE CAT_PARENTID != 0');
    }


    public function getAllSubCategoryActive()
    {
        return DB::select('SELECT * FROM `category` WHERE CAT_PARENTID != 0 AND CAT_STATUS = "ACTIVE"');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting category 
        * @param        : Request data  
        * @return       : return with inserting category
    */
    public function create(array $attributes)
    {
        return DB::table('m36_category')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating category 
        * @param        : Request data  
        * @return       : return with updating category
    */
    public function update($id, array $attributes)
    {
        return DB::table('m36_category')->where('m36_cat_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting category 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function delete($id)
    {
        return DB::table('m36_category')->where('m36_cat_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single category data 
        * @param        : Request data  
        * @return       : return with single category data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `category` WHERE CAT_ID = "'.$id.'"');
    }   

    public function getByName($id)
    {   
        return DB::select('SELECT * FROM `category` WHERE CAT_NAME = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating category status
        * @param        : Request data with category id
        * @return       : return with updated category status
    */
    public function active($id)
    {
        return DB::update('UPDATE m36_category SET m36_status = case m36_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m36_cat_id = "'.$id.'"');
    }

	/**
        * Method name   : getSubCatById
        * @description  : Used for getting sub category by id 
        * @param        : Request data  
        * @return       : return all category data
    */
    public function getSubCatById($id)
    {
        return DB::select('SELECT * FROM `category` WHERE CAT_PARENTID ='.$id);
    }

    public function getSubCatByName($name)
    {
        return DB::select('SELECT * FROM `category` WHERE CAT_PARENT_NAME ="'.$name.'"');
    }

	 /**
        * Method name   : Get Sub Category By parent 
        * @description  : Used for getting sub category by parent 
        * @param        : Request data  
        * @return       : return all sub category by parent
    */
    public function getSubCategoryByParent($id)
    {
        return DB::select('SELECT * FROM `category` WHERE CAT_PARENTID ='.$id);
    }

    /**
        * Method name   : Get by shopping for
        * @description  : Used for getting all category data with shopping for
        * @param        : Request data  
        * @return       : return all category data with shopping for
    */
    public function getByShoppingFor($id)
    {
        return DB::select('SELECT * FROM `category` WHERE SHOPPING_FOR = '.$id);
    }

	/**
        * Method name   : Get by shopping for
        * @description  : Used for getting all category data with shopping for
        * @param        : Request data  
        * @return       : return all category data with shopping for
    */
    public function getAllByShoppingFor($id)
    {
        return DB::select('SELECT * FROM `category` WHERE SHOPPING_FOR = '.$id.'');
    }
}

