<?php

namespace App\Repositories\ProductModule\Brand;

use DB;

class EloquentBrand implements BrandRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all brands data 
        * @param        : Request data  
        * @return       : return all brands data
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `brands`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting brand 
        * @param        : Request data  
        * @return       : return with inserting brand
    */
    public function create(array $attributes)
    {
        return DB::table('m34_brands')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating brand 
        * @param        : Request data  
        * @return       : return with updating brand
    */
    public function update($id, array $attributes)
    {
        return DB::table('m34_brands')->where('m34_brand_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting brand 
        * @param        : Request data  
        * @return       : return with deleting brand
    */
    public function delete($id)
    {
        return DB::table('m34_brands')->where('m34_brand_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single brand data 
        * @param        : Request data  
        * @return       : return with single brand data
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `brands` WHERE BRAND_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating brand status
        * @param        : Request data with brand id
        * @return       : return with updated brand status
    */
    public function active($id)
    {
        return DB::update('UPDATE m34_brands SET m34_brand_status = case m34_brand_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m34_brand_id = "'.$id.'"');
    }
}




