<?php

namespace App\Repositories\Product;

use DB;

class EloquentProduct implements ProductRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all products data 
        * @param        : Request data  
        * @return       : return all products data
    */
    public function getAll()
    {
        return DB::table('m41_product_details')->paginate(500);
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting product 
        * @param        : Request data  
        * @return       : return with inserting product
    */
    public function create(array $attributes)
    {
        return DB::table('m41_product_details')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating product 
        * @param        : Request data  
        * @return       : return with updating product
    */
    public function update($id, array $attributes)
    {
        return DB::table('m41_product_details')->where('m41_product_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting product 
        * @param        : Request data  
        * @return       : return with deleting product
    */
    public function delete($id)
    {
        return DB::table('m41_product_details')->where('m41_product_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single product data 
        * @param        : Request data  
        * @return       : return with single product data
    */
    public function getById($id)
    {   
        return DB::table('m41_product_details')->where('m41_product_id', $id)->get();
    }

    /**
        * Method name   : Active
        * @description  : Used for updating product status
        * @param        : Request data with product id
        * @return       : return with updated product status
    */
    public function active($id)
    {
        return DB::update('UPDATE m41_product_details SET m41_product_status = case m41_product_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m41_product_id = "'.$id.'"');
    }


    /**
        * Method name   : Get all prod stock
        * @description  : Used for getting all products stock 
        * @param        : Request data  
        * @return       : return all products stock
    */
    public function getAllProdStock()
    {
        return DB::table('m42_prod_stock')->paginate(500);
    }

    /**
        * Method name   : Get stock by prod id
        * @description  : Used for getting stock by product id
        * @param        : Request data  
        * @return       : return with single stock of product
    */
    public function getStockByProdId($id)
    {   
        return DB::table('m42_prod_stock')->where('m42_stock_id', $id)->get();
    }

    /**
        * Method name   : Create Stock
        * @description  : Used for inserting product stock
        * @param        : Request data  
        * @return       : return with inserting product stock
    */
    public function createStock(array $attributes)
    {
        return DB::table('m42_prod_stock')->insert($attributes);
    }
}




