<?php

namespace App\Repositories\Pantoken;

use DB;

class EloquentPantoken implements PantokenRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all 
        * @description  : Used for getting all data 
        * @param        : Request data  
        * @return       : return all 
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM pan_token');
    }


    /**
        * Method name   : Create
        * @description  : Used for inserting category 
        * @param        : Request data  
        * @return       : return with inserting category
    */
    public function create(array $attributes)
    {
        return DB::table('tr40_pan_token')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating category 
        * @param        : Request data  
        * @return       : return with updating category
    */
    public function update($id, array $attributes)
    {
        return DB::table('tr40_pan_token')->where('tr40_pan_token_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting category 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function delete($id)
    {
        return DB::table('tr40_pan_token')->where('tr40_pan_token_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single category data 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM pan_token WHERE TOKEN_ID='.$id.'');
    }

    /**
        * Method name   : Get by user id
        * @description  : Used for getting single category data 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function getByUserId($id)
    {   
        return DB::select('SELECT * FROM pan_token WHERE USER_ID='.$id.'');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating category status
        * @param        : Request data with category id
        * @return       : return with updated category status
    */
    public function active($id)
    {
        return DB::update('UPDATE tr40_pan_token SET tr40_pt_status = case tr40_pt_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE tr40_pan_token_id = "'.$id.'"');
    }

}




