<?php

namespace App\Repositories\OrderReturn;

use DB;

class EloquentOrderReturn implements OrderReturnRepository
{
    
    private $model;
    private $table = "m72_cart_return";
    private $view = 'order_return';

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    public function getAll()
    {
        return $this->model::table($this->view)->get();
    }

    public function create(array $attributes)
    {
        return $this->model::table($this->table)->insertGetId($attributes);
    }

    public function update($id, array $attributes)
    {
        return $this->model::table($this->table)->where('m72_id', $id)->update($attributes);
    }

    public function delete($id)
    {
        return $this->model::table($this->table)->where('m72_id', $id)->delete();
    }

    public function getById($id)
    {   
        return $this->model::table($this->view)->where('RETURN_ID', $id)->get();
    }

    public function getByUserId($id)
    {   
        return $this->model::table($this->table)->where('m11_user_id', $id)->get();
    }

}




