<?php

namespace App\Repositories\Master\WlConfig;

use DB;
use Helper;

class EloquentWlConfig implements WlConfigRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }


    public function getAll()
    {
        return DB::table('set_config_wl')->get();
    }



    public function create($data)
    {
        return DB::table('m00_setconfig_wl')->insert($data);
    }


    public function getByIds($id)
    {
        return DB::table('set_config_wl')->where('SC_ID' , $id)->get();
    }

    public function update($id, array $attributes)
    {
        return DB::table('m00_setconfig_wl')->where('m00_id',$id)->update($attributes);
    }



    /**
        * Method name   : get by id
        * @description  : Used for getting by id
        * @param        : Request data with config id
        * @return       : return with config id
    */
    public function getById($id, $affid)
    {
        return DB::table('m00_setconfig_wl')->where('m00_id' , $id)->where('m00_affid',$affid)->get();
    }


    /**
        * Method name   : get by affid
        * @description  : Used for getting by affid
        * @param        : Request data with config id
        * @return       : return with config id
    */
    public function getByAffid($affid)
    {
        return DB::table('m00_setconfig_wl')->where('m00_affid',$affid)->get();
    }

    /**
        * Method name   : Update with id
        * @description  : Used for updating wl config with id
        * @param        : Request data with config id
        * @return       : return with updated config
    */
    public function updateWithId($id, $affid, array $attributes)
    {
        return DB::table('m00_setconfig_wl')->where('m00_id',$id)->where('m00_affid',$affid)->update($attributes);
    }

    /**
        * Method name   : Update with name
        * @description  : Used for updating wl config with name
        * @param        : Request data with config name
        * @return       : return with updated config
    */
    public function updateWithName($name, $affid, array $attributes)
    {
        return DB::table('m00_setconfig_wl')->where('m00_name',$name)->where('m00_affid',$affid)->update($attributes);
    }

    

}



