<?php

namespace App\Repositories\Master\Usermenu;

use DB;
use Helper;

class EloquentUsermenu implements UsermenuRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all assign menu
        * @param        : Request data
        * @return       : return all assign menu
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `user_assign_menu`');
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all parent assign menu
        * @param        : Request data
        * @return       : return all parent assign menu
    */
    public function getAllParent()
    {
        return DB::select('SELECT * FROM `user_assign_menu` WHERE ASMENU_PARENTID = -1');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting assign menu
        * @param        : Request data
        * @return       : return created assign menu
    */
    public function create(array $attributes)
    {
		if($attributes['m30_employee_id']='-1'){
            $user=$attributes['m11_user_id'];
        }
        elseif($attributes['m11_user_id']='-1') {
            $user=$attributes['m30_employee_id'];
        }

        Helper::notify_data($attributes,1,"NEW MENU ASSIGNED TO USER SUCCESSFULLY","MENU ASSIGNED TO USER ID ".$user."",0,'2');
        return DB::table('m50_user_assign_menu')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating assign menu
        * @param        : Request data
        * @return       : return updated assign menu
    */
    public function update($id, array $attributes)
    {
        return DB::table('m50_user_assign_menu')->where('m50_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting assign menu
        * @param        : Request data
        * @return       : return deleted assign menu
    */
    public function delete($id)
    {
        return DB::table('m50_user_assign_menu')->where('m50_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single assign menu with id
        * @param        : Request data with assign menu id
        * @return       : return single assign menu
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `user_assign_menu` WHERE USRMN_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating assign menu status
        * @param        : Request data with assign menu id
        * @return       : return assign menu with staus updated
    */
    public function active($id)
    {
        return DB::update('UPDATE m50_user_assign_menu SET m50_status = case m50_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m50_id = "'.$id.'"');
    }

}



