<?php

namespace App\Repositories\Master\Translation;

use DB;
use Helper;


class EloquentTranslation implements TranslationRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    public function getAll()
    {
        return DB::select('SELECT * FROM `translation`');
    }

    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW TRANSLATION VALUE INSERTED SUCCESSFULLY",$attributes['m48_translated_text'],0,'2');
        return DB::table('m48_translation')->insert($attributes);
    }

    public function update($id, array $attributes)
    {
        return DB::table('m48_translation')->where('m48_id', $id)->update($attributes);
    }

    public function delete($id)
    {
        return DB::table('m48_translation')->where('m48_id', $id)->delete();
    }

    public function getById($id)
    {   
        return DB::select('SELECT * FROM `translation` WHERE TRANS_ID = "'.$id.'"');
    }

    public function getByType($locale, $type)
    {   
        return DB::select('SELECT * FROM `translation` WHERE TRANS_LANG = "'.$locale.'" AND TRANS_TYPE = "'.$type.'"');
    }

    public function getByName($name)
    {   
        return DB::table('m48_translation')->where('m48_translated_for', $name)->get();
    }

    public function update_transfor($name, array $attributes)
    {
        return DB::table('m48_translation')->where('m48_translated_for', $name)->update($attributes);
    }

}



