<?php

namespace App\Repositories\Master\Service;

use DB;
use Helper;

class EloquentService implements ServiceRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all services
        * @param        : Request data
        * @return       : return all services
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `services`');
    }


    public function getservice()
    {
        return DB::select('SELECT * FROM `services` WHERE SR_TYPE != "BBPS" AND SR_STATUS="Active"');
    }



    public function getbbpsservice()
    {
        return DB::select('SELECT * FROM `services` WHERE SR_TYPE = "BBPS" AND SR_STATUS="Active"');
    }


    /**
        * Method name   : Create
        * @description  : Used for inserting service
        * @param        : Request data
        * @return       : return created service
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW SERVICE INSERTED SUCCESSFULLY",$attributes['m03_service_name'],0,'2');
        return DB::table('m03_service_type')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating service
        * @param        : Request data
        * @return       : return updated service
    */
    public function update($id, array $attributes)
    {
        return DB::table('m03_service_type')->where('m03_sr_type_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting service
        * @param        : Request data
        * @return       : return deleted service
    */
    public function delete($id)
    {
        return DB::table('m03_service_type')->where('m03_sr_type_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single service with id
        * @param        : Request data with service id
        * @return       : return single service
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `services` WHERE SR_TYPEID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating service status
        * @param        : Request data with service id
        * @return       : return service with staus updated
    */
    public function active($id)
    {
        return DB::update('UPDATE m03_service_type SET m03_sr_type_status = case m03_sr_type_status when "Active" then "InActive"
         when "InActive" then "Active" end WHERE m03_sr_type_id = "'.$id.'"');
    }

}

