<?php

namespace App\Repositories\Master\Role;

use DB;

class EloquentRole implements RoleRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all roles
        * @param        : Request data
        * @return       : return all roles
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `roles`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating role
        * @param        : Request data
        * @return       : return with created role
    */
    public function create(array $attributes)
    {
        return DB::table('m65_roles')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating role
        * @param        : Request data with role id
        * @return       : return with updated role
    */
    public function update($id, array $attributes)
    {
        return DB::table('m65_roles')->where('m65_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting role
        * @param        : Request data with role id
        * @return       : return with deleted role
    */
    public function delete($id)
    {
        return DB::table('m65_roles')->where('m65_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single role 
        * @param        : Request data with role id
        * @return       : return with single role details
    */
    public function getById($id)
    {   
        return  DB::select('SELECT * FROM `roles` WHERE ROLE_ID = "'.$id.'"');
    }



    /**
        * Method name   : Get By Id
        * @description  : Used for getting single role 
        * @param        : Request data with role id
        * @return       : return with single role details
    */
    public function getByPId($id)
    {   
        return  DB::select('SELECT * FROM `roles` WHERE PARENT_ROLE_ID = "'.$id.'"');
    }


}



