<?php

namespace App\Repositories\Master\Package;

use DB;

class EloquentPackage implements PackageRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all package
        * @param        : Request data
        * @return       : return all packages
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `package`');
    }
/**
        * Method name   : Get all
        * @description  : Used for getting all package
        * @param        : Request data
        * @return       : return all packages
    */
    public function getAllforAdmin()
    {
        return DB::select('SELECT * FROM `package_foradmin`');
    }
    /**
        * Method name   : Create
        * @description  : Used for creating package
        * @param        : Request data
        * @return       : return created package
    */
    public function create(array $attributes)
    {
        return DB::table('m27_package')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating package
        * @param        : Request data with package id
        * @return       : return updated package
    */
    public function update($id, array $attributes)
    {
        return DB::table('m27_package')->where('m27_pack_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting package
        * @param        : Request data with package id
        * @return       : return deleted package
    */
    public function delete($id)
    {
        return DB::table('m27_package')->where('m27_pack_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single package
        * @param        : Request data with package id
        * @return       : return single package
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `package` WHERE PACKAGE_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating package status
        * @param        : Request data with package id
        * @return       : return updated package
    */
    public function active($id)
    {
        return DB::update('UPDATE m27_package SET m27_pack_status = case m27_pack_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m27_pack_id = "'.$id.'"');
    }

    /**
        * Method name   : Get all from view
        * @description  : Used for getting all package from view package
        * @param        : Request data
        * @return       : return all packages
    */
    public function getAllPackage()
    {
        return DB::select("SELECT * FROM `package` WHERE PACKAGE_STATUS=1");
    }
}




