<?php

namespace App\Repositories\Master\Operator;

use DB;
use Helper;

class EloquentOperator implements OperatorRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all operators
        * @param        : Request data
        * @return       : return all operators
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `telecom_brand`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting operators
        * @param        : Request data
        * @return       : return with inserted operator
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW OPERATOR INSERTED SUCCESSFULLY",$attributes['m04_tc_brand_name'],0,'2');
        return DB::table('m04_telecom_brand')->insertGetId($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating operator
        * @param        : Request data with operator id
        * @return       : return with updated operator
    */
    public function update($id, array $attributes)
    {
        return DB::table('m04_telecom_brand')->where('m04_tc_brand_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleteing operator
        * @param        : Request data with operator id
        * @return       : return with deleted operator
    */
    public function delete($id)
    {
        return DB::table('m04_telecom_brand')->where('m04_tc_brand_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single operator
        * @param        : Request data with operator id
        * @return       : return with single operator
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `telecom_brand` WHERE TelecomBrandId = "'.$id.'"');
    }

    public function getByServiceId($id)
    {   
        return DB::select('SELECT * FROM `telecom_brand` WHERE ServiceTypeId = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating status
        * @param        : Request data with operator id
        * @return       : return with updated single operator status
    */
    public function active($id)
    {
        return DB::update('UPDATE m04_telecom_brand SET m04_tc_brand_status = case m04_tc_brand_status when "Active" then "InActive"
         when "InActive" then "Active" end WHERE m04_tc_brand_id = "'.$id.'"');
    }

/**
        * Method name   : Order By Service Type Id
        * @description  : Used for getting all operators order by service type id
        * @param        : Request data with operators
        * @return       : return with operators
    */
    public function OrderByServiceTypeId()
    {
        return DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
    }


}

