<?php

namespace App\Repositories\Master\Message;

use DB;
use Helper;

class EloquentMessage implements MessageRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all message config
        * @param        : Request data
        * @return       : return all message config
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `config_msg`');
    }


    public function getAllCamp()
    {
        return DB::select('SELECT * FROM `config_msg` WHERE MSG_TYPE = "CAMPAIGAN" ');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating message config
        * @param        : Request data
        * @return       : return with creating message config
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW MESSAGE CONTENT INSERTED SUCCESSFULLY",$attributes['m09_msg_title'],0,'2');
        return DB::table('m09_message_config')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating message config
        * @param        : Request data with message config id
        * @return       : return with updated message config
    */
    public function update($id, array $attributes)
    {
        return DB::table('m09_message_config')->where('m09_msg_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting message config
        * @param        : Request data with message config id
        * @return       : return with deleting message config
    */
    public function delete($id)
    {
        return DB::table('m09_message_config')->where('m09_msg_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single message config
        * @param        : Request data with message config id
        * @return       : return with single message config
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `config_msg` WHERE MSG_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating status
        * @param        : Request data with message config id
        * @return       : return with updated message config status 
    */
    public function active($id)
    {
        return DB::update('UPDATE m09_message_config SET m09_msg_status = case m09_msg_status when "Active" then "InActive"
         when "InActive" then "Active" end WHERE m09_msg_id = "'.$id.'"');
    }

}


