<?php

namespace App\Repositories\Master\Location;

use DB;
use Helper;

class EloquentLocation implements LocationRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all countries
        * @description  : Used for getting all countries data 
        * @param        : Request data  
        * @return       : return all countries data
    */
    public function getAllCountries()
    {
        return DB::select('SELECT * FROM `location` WHERE LOC_PARENTID ="-1" ORDER BY LOC_NAME');
    }

    /**
        * Method name   : Get all states
        * @description  : Used for getting all states data 
        * @param        : Request data  
        * @return       : return all states data
    */
    public function getAllStates()
    {
        return DB::select('SELECT * FROM `location` WHERE LOC_PARENTID ="1"');
    }

    /**
        * Method name   : Get all cities
        * @description  : Used for getting all cities data 
        * @param        : Request data  
        * @return       : return all cities data
    */
    public function getAllCities()
    {
        return DB::select('SELECT * FROM `location` WHERE LOC_PARENTID !="1" AND LOC_PARENTID !="-1"');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting country 
        * @param        : Request data  
        * @return       : return with inserting country
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW LOCATION INSERTED SUCCESSFULLY",$attributes['m02_loc_name'],0,'2');
        return DB::table('m02_location')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating country 
        * @param        : Request data  
        * @return       : return with updating country
    */
    public function update($id, array $attributes)
    {
        return DB::table('m02_location')->where('m02_loc_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting country 
        * @param        : Request data  
        * @return       : return with deleting country
    */
    public function delete($id)
    {
        return DB::table('m02_location')->where('m02_loc_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single country data 
        * @param        : Request data  
        * @return       : return with deleting country
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `location` WHERE LOC_ID ="'.$id.'"');
    }



    /**
        * Method name   : Get by pid
        * @description  : Used for getting single country data 
        * @param        : Request data  
        * @return       : return with deleting country
    */
    public function getByPId($id)
    {   
        return DB::select('SELECT * FROM `location` WHERE LOC_PARENTID ="'.$id.'"');
    }



    /**
        * Method name   : Active
        * @description  : Used for updating city status
        * @param        : Request data with city id
        * @return       : return with updated city status
    */
    public function active($id)
    {
        return DB::update('UPDATE m02_location SET m02_status = case m02_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m02_loc_id = "'.$id.'"');
    }

}


