<?php

namespace App\Repositories\Master\LevelCommissionType;

use DB;

class EloquentLevelCommissionTypes implements LevelCommissionTypesRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all roles
        * @param        : Request data
        * @return       : return all roles
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `level_commission`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating role
        * @param        : Request data
        * @return       : return with created role
    */
    public function create(array $attributes)
    {
        return DB::table('m78_levelw_commission')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating role
        * @param        : Request data with role id
        * @return       : return with updated role
    */
    public function updateservice($sno, $id, array $attributes)
    {
        return DB::table('m78_levelw_commission')->where('m78_level', $sno)->where('m03_services', $id)->update($attributes);
    }

    public function updatetopup($sno, $id, array $attributes)
    {
        return DB::table('m78_levelw_commission')->where('m78_level', $sno)->where('m27_topup_id', $id)->update($attributes);
    }


    /**
        * Method name   : Delete
        * @description  : Used for deleting role
        * @param        : Request data with role id
        * @return       : return with deleted role
    */
    public function delete($id)
    {
        return DB::table('m78_levelw_commission')->where('m78_lvl_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single role 
        * @param        : Request data with role id
        * @return       : return with single role details
    */
    public function getById($id)
    {   
        return  DB::select('SELECT * FROM `m78_levelw_commission` WHERE m78_lvl_id = "'.$id.'"');
    }


    public function getByServicId($id)
    {   
        return  DB::select('SELECT * FROM `m78_levelw_commission` WHERE m03_services = "'.$id.'" ORDER BY m78_level ASC');
    }


    public function getByTopupId($id)
    {   
        return  DB::select('SELECT * FROM `m78_levelw_commission` WHERE m27_topup_id = "'.$id.'" ORDER BY m78_level ASC');
    }

}